/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.time;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.expression.time.ExprTimePeriodImpl;
import java.util.Calendar;
import java.util.TimeZone;

public class ExprTimePeriodEvalDeltaNonConstCalAdd
implements ExprTimePeriodEvalDeltaNonConst {
    private final Calendar cal;
    private final ExprTimePeriodImpl parent;

    public ExprTimePeriodEvalDeltaNonConstCalAdd(TimeZone timeZone, ExprTimePeriodImpl parent) {
        this.parent = parent;
        this.cal = Calendar.getInstance(timeZone);
    }

    @Override
    public synchronized long deltaMillisecondsAdd(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        this.cal.setTimeInMillis(currentTime);
        this.addSubtract(this.parent, this.cal, 1, eventsPerStream, isNewData, context);
        return this.cal.getTimeInMillis() - currentTime;
    }

    @Override
    public synchronized long deltaMillisecondsSubtract(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        this.cal.setTimeInMillis(currentTime);
        this.addSubtract(this.parent, this.cal, -1, eventsPerStream, isNewData, context);
        return this.cal.getTimeInMillis() - currentTime;
    }

    @Override
    public synchronized long deltaMillisecondsUseEngineTime(EventBean[] eventsPerStream, AgentInstanceContext agentInstanceContext) {
        long currentTime = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        this.cal.setTimeInMillis(currentTime);
        this.addSubtract(this.parent, this.cal, 1, eventsPerStream, true, agentInstanceContext);
        return this.cal.getTimeInMillis() - currentTime;
    }

    @Override
    public synchronized ExprTimePeriodEvalDeltaResult deltaMillisecondsAddWReference(long current, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long last;
        if (reference > current) {
            while (reference > current) {
                reference -= this.deltaMillisecondsSubtract(reference, eventsPerStream, isNewData, context);
            }
        }
        long next = reference;
        while ((next += this.deltaMillisecondsAdd(last = next, eventsPerStream, isNewData, context)) <= current) {
        }
        return new ExprTimePeriodEvalDeltaResult(next - current, last);
    }

    private void addSubtract(ExprTimePeriodImpl parent, Calendar cal, int factor, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        ExprTimePeriodImpl.TimePeriodAdder[] adders = parent.getAdders();
        ExprEvaluator[] evaluators = parent.getEvaluators();
        for (int i = 0; i < adders.length; ++i) {
            int value = ((Number)evaluators[i].evaluate(eventsPerStream, newData, context)).intValue();
            adders[i].add(cal, factor * value);
        }
    }
}

