/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.StreamJoinAnalysisResult;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyComposite;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyInKeywordMulti;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyInKeywordSingle;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyIndex;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyIndexSingle;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyNoIndex;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategySorted;
import com.espertech.esper.epl.join.base.HistoricalViewableDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeHistorical2StreamImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeImpl;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.CoercionUtil;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzer;
import com.espertech.esper.epl.join.plan.OuterJoinAnalyzer;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryInKeywordSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyComposite;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyIndex;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyIndexCoerce;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyIndexCoerceSingle;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyIndexSingle;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyIndexSingleArray;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyNoIndex;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategySorted;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescHistorical;
import com.espertech.esper.epl.join.util.QueryPlanIndexHook;
import com.espertech.esper.epl.join.util.QueryPlanIndexHookUtil;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.DependencyGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JoinSetComposerPrototypeFactory {
    private static final Log queryPlanLog = LogFactory.getLog((String)"com.espertech.esper.queryplan");
    private static final Log log = LogFactory.getLog(JoinSetComposerPrototypeFactory.class);

    public static JoinSetComposerPrototype makeComposerPrototype(String statementName, String statementId, OuterJoinDesc[] outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, String[] streamNames, StreamJoinAnalysisResult streamJoinAnalysisResult, boolean queryPlanLogging, StatementContext statementContext, HistoricalViewableDesc historicalViewableDesc, ExprEvaluatorContext exprEvaluatorContext, boolean selectsRemoveStream, boolean hasAggregations, TableService tableService, boolean isOnDemandQuery) throws ExprValidationException {
        DependencyGraph historicalDependencyGraph = new DependencyGraph(streamTypes.length, false);
        for (int i = 0; i < streamTypes.length; ++i) {
            if (!historicalViewableDesc.getHistorical()[i]) continue;
            SortedSet<Integer> streamsThisStreamDependsOn = historicalViewableDesc.getDependenciesPerHistorical()[i];
            historicalDependencyGraph.addDependency(i, streamsThisStreamDependsOn);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dependency graph: " + historicalDependencyGraph));
        }
        if (historicalViewableDesc.isHasHistorical() && streamTypes.length == 2) {
            return JoinSetComposerPrototypeFactory.makeComposerHistorical2Stream(outerJoinDescList, optionalFilterNode, streamTypes, historicalViewableDesc, queryPlanLogging, exprEvaluatorContext, statementContext, streamNames);
        }
        boolean isOuterJoins = !OuterJoinDesc.consistsOfAllInnerJoins(outerJoinDescList);
        ExcludePlanHint hint = ExcludePlanHint.getHint(streamNames, statementContext);
        QueryGraph queryGraph = new QueryGraph(streamTypes.length, hint, false);
        if (outerJoinDescList.length > 0) {
            OuterJoinAnalyzer.analyze(outerJoinDescList, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug((Object)(".makeComposer After outer join queryGraph=\n" + queryGraph));
            }
        }
        if (optionalFilterNode != null) {
            FilterExprAnalyzer.analyze(optionalFilterNode, queryGraph, isOuterJoins);
            if (log.isDebugEnabled()) {
                log.debug((Object)(".makeComposer After filter expression queryGraph=\n" + queryGraph));
            }
            QueryGraph.fillEquivalentNav(streamTypes, queryGraph);
            if (log.isDebugEnabled()) {
                log.debug((Object)(".makeComposer After fill equiv. nav. queryGraph=\n" + queryGraph));
            }
        }
        HistoricalStreamIndexList[] historicalStreamIndexLists = new HistoricalStreamIndexList[streamTypes.length];
        QueryPlan queryPlan = QueryPlanBuilder.getPlan(streamTypes, outerJoinDescList, queryGraph, streamNames, historicalViewableDesc, historicalDependencyGraph, historicalStreamIndexLists, streamJoinAnalysisResult, queryPlanLogging, statementContext.getAnnotations(), exprEvaluatorContext);
        HashSet<TableLookupIndexReqKey> usedIndexes = new HashSet<TableLookupIndexReqKey>();
        QueryPlanIndex[] indexSpecs = queryPlan.getIndexSpecs();
        for (int streamNum = 0; streamNum < queryPlan.getExecNodeSpecs().length; ++streamNum) {
            QueryPlanNode planNode = queryPlan.getExecNodeSpecs()[streamNum];
            if (planNode == null) continue;
            planNode.addIndexes(usedIndexes);
        }
        for (QueryPlanIndex indexSpec : indexSpecs) {
            TableLookupIndexReqKey[] indexNames;
            if (indexSpec == null) continue;
            Map<TableLookupIndexReqKey, QueryPlanIndexItem> items = indexSpec.getItems();
            for (TableLookupIndexReqKey indexName : indexNames = items.keySet().toArray(new TableLookupIndexReqKey[items.size()])) {
                if (usedIndexes.contains(indexName)) continue;
                items.remove(indexName);
            }
        }
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(statementContext.getAnnotations());
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            queryPlanLog.info((Object)("Query plan: " + queryPlan.toQueryPlan()));
            if (hook != null) {
                hook.join(queryPlan);
            }
        }
        if (!isOnDemandQuery) {
            for (TableLookupIndexReqKey usedIndex : usedIndexes) {
                if (usedIndex.getTableName() == null) continue;
                tableService.getTableMetadata(usedIndex.getTableName()).addIndexReference(usedIndex.getName(), statementName);
            }
        }
        boolean joinRemoveStream = selectsRemoveStream || hasAggregations;
        return new JoinSetComposerPrototypeImpl(statementName, statementId, outerJoinDescList, optionalFilterNode, streamTypes, streamNames, streamJoinAnalysisResult, statementContext.getAnnotations(), historicalViewableDesc, exprEvaluatorContext, indexSpecs, queryPlan, historicalStreamIndexLists, joinRemoveStream, isOuterJoins, tableService);
    }

    private static JoinSetComposerPrototype makeComposerHistorical2Stream(OuterJoinDesc[] outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, HistoricalViewableDesc historicalViewableDesc, boolean queryPlanLogging, ExprEvaluatorContext exprEvaluatorContext, StatementContext statementContext, String[] streamNames) throws ExprValidationException {
        int polledViewNum = 0;
        int streamViewNum = 1;
        if (historicalViewableDesc.getHistorical()[1]) {
            streamViewNum = 0;
            polledViewNum = 1;
        }
        boolean isAllHistoricalNoSubordinate = false;
        if (historicalViewableDesc.getHistorical()[0] && historicalViewableDesc.getHistorical()[1]) {
            DependencyGraph graph = new DependencyGraph(2, false);
            graph.addDependency(0, historicalViewableDesc.getDependenciesPerHistorical()[0]);
            graph.addDependency(1, historicalViewableDesc.getDependenciesPerHistorical()[1]);
            if (graph.getFirstCircularDependency() != null) {
                throw new ExprValidationException("Circular dependency detected between historical streams");
            }
            if (graph.getRootNodes().size() == 2) {
                isAllHistoricalNoSubordinate = true;
            } else if (graph.getDependenciesForStream(0).size() == 0) {
                streamViewNum = 0;
                polledViewNum = 1;
            } else {
                streamViewNum = 1;
                polledViewNum = 0;
            }
        }
        boolean isOuterJoin = false;
        ExprNode outerJoinEqualsNode = null;
        boolean isInnerJoinOnly = false;
        if (outerJoinDescList.length > 0) {
            OuterJoinDesc outerJoinDesc = outerJoinDescList[0];
            isInnerJoinOnly = outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.INNER);
            if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && streamViewNum == 0) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && streamViewNum == 1) {
                isOuterJoin = true;
            }
            outerJoinEqualsNode = outerJoinDesc.makeExprNode(exprEvaluatorContext);
        }
        ExprNode filterForIndexing = null;
        if (outerJoinEqualsNode != null && optionalFilterNode != null && isInnerJoinOnly) {
            filterForIndexing = new ExprAndNodeImpl();
            filterForIndexing.addChildNode(optionalFilterNode);
            filterForIndexing.addChildNode(outerJoinEqualsNode);
        } else if (outerJoinEqualsNode == null && optionalFilterNode != null) {
            filterForIndexing = optionalFilterNode;
        } else if (outerJoinEqualsNode != null) {
            filterForIndexing = outerJoinEqualsNode;
        }
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies = JoinSetComposerPrototypeFactory.determineIndexing(filterForIndexing, streamTypes[polledViewNum], streamTypes[streamViewNum], polledViewNum, streamViewNum, statementContext, streamNames);
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(statementContext.getAnnotations());
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            queryPlanLog.info((Object)("historical lookup strategy: " + indexStrategies.getFirst().toQueryPlan()));
            queryPlanLog.info((Object)("historical index strategy: " + indexStrategies.getSecond().toQueryPlan()));
            if (hook != null) {
                hook.historical(new QueryPlanIndexDescHistorical(indexStrategies.getFirst().getClass().getSimpleName(), indexStrategies.getSecond().getClass().getSimpleName()));
            }
        }
        return new JoinSetComposerPrototypeHistorical2StreamImpl(optionalFilterNode, streamTypes, exprEvaluatorContext, polledViewNum, streamViewNum, isOuterJoin, outerJoinEqualsNode, indexStrategies, isAllHistoricalNoSubordinate, outerJoinDescList);
    }

    private static Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> determineIndexing(ExprNode filterForIndexing, EventType polledViewType, EventType streamViewType, int polledViewStreamNum, int streamViewStreamNum, StatementContext statementContext, String[] streamNames) throws ExprValidationException {
        if (filterForIndexing == null) {
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        ExcludePlanHint hint = ExcludePlanHint.getHint(streamNames, statementContext);
        QueryGraph queryGraph = new QueryGraph(2, hint, false);
        FilterExprAnalyzer.analyze(filterForIndexing, queryGraph, false);
        return JoinSetComposerPrototypeFactory.determineIndexing(queryGraph, polledViewType, streamViewType, polledViewStreamNum, streamViewStreamNum);
    }

    public static Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> determineIndexing(QueryGraph queryGraph, EventType polledViewType, EventType streamViewType, int polledViewStreamNum, int streamViewStreamNum) {
        QueryGraphValue queryGraphValue = queryGraph.getGraphValue(streamViewStreamNum, polledViewStreamNum);
        QueryGraphValuePairHashKeyIndex hashKeysAndIndes = queryGraphValue.getHashKeyProps();
        QueryGraphValuePairRangeIndex rangeKeysAndIndex = queryGraphValue.getRangeProps();
        List<QueryGraphValueEntryHashKeyed> hashKeys = hashKeysAndIndes.getKeys();
        String[] hashIndexes = hashKeysAndIndes.getIndexed();
        List<QueryGraphValueEntryRange> rangeKeys = rangeKeysAndIndex.getKeys();
        String[] rangeIndexes = rangeKeysAndIndex.getIndexed();
        if (hashKeys.isEmpty() && rangeKeys.isEmpty()) {
            QueryGraphValuePairInKWSingleIdx inKeywordSingles = queryGraphValue.getInKeywordSingles();
            if (inKeywordSingles != null && inKeywordSingles.getIndexed().length != 0) {
                String indexed = inKeywordSingles.getIndexed()[0];
                QueryGraphValueEntryInKeywordSingleIdx lookup = inKeywordSingles.getKey().get(0);
                HistoricalIndexLookupStrategyInKeywordSingle strategy = new HistoricalIndexLookupStrategyInKeywordSingle(streamViewStreamNum, lookup.getKeyExprs());
                PollResultIndexingStrategyIndexSingle indexing = new PollResultIndexingStrategyIndexSingle(polledViewStreamNum, polledViewType, indexed);
                return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
            }
            List<QueryGraphValuePairInKWMultiIdx> multis = queryGraphValue.getInKeywordMulti();
            if (!multis.isEmpty()) {
                QueryGraphValuePairInKWMultiIdx multi = multis.get(0);
                HistoricalIndexLookupStrategyInKeywordMulti strategy = new HistoricalIndexLookupStrategyInKeywordMulti(streamViewStreamNum, multi.getKey().getKeyExpr());
                PollResultIndexingStrategyIndexSingleArray indexing = new PollResultIndexingStrategyIndexSingleArray(polledViewStreamNum, polledViewType, ExprNodeUtility.getIdentResolvedPropertyNames(multi.getIndexed()));
                return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
            }
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        CoercionDesc keyCoercionTypes = CoercionUtil.getCoercionTypesHash(new EventType[]{streamViewType, polledViewType}, 0, 1, hashKeys, hashIndexes);
        if (rangeKeys.isEmpty()) {
            if (!keyCoercionTypes.isCoerce()) {
                if (hashIndexes.length == 1) {
                    PollResultIndexingStrategyIndexSingle indexing = new PollResultIndexingStrategyIndexSingle(polledViewStreamNum, polledViewType, hashIndexes[0]);
                    HistoricalIndexLookupStrategyIndexSingle strategy = new HistoricalIndexLookupStrategyIndexSingle(streamViewStreamNum, hashKeys.get(0));
                    return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
                }
                PollResultIndexingStrategyIndex indexing = new PollResultIndexingStrategyIndex(polledViewStreamNum, polledViewType, hashIndexes);
                HistoricalIndexLookupStrategyIndex strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, streamViewStreamNum, hashKeys);
                return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
            }
            if (hashIndexes.length == 1) {
                PollResultIndexingStrategyIndexCoerceSingle indexing = new PollResultIndexingStrategyIndexCoerceSingle(polledViewStreamNum, polledViewType, hashIndexes[0], keyCoercionTypes.getCoercionTypes()[0]);
                HistoricalIndexLookupStrategyIndexSingle strategy = new HistoricalIndexLookupStrategyIndexSingle(streamViewStreamNum, hashKeys.get(0));
                return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
            }
            PollResultIndexingStrategyIndexCoerce indexing = new PollResultIndexingStrategyIndexCoerce(polledViewStreamNum, polledViewType, hashIndexes, keyCoercionTypes.getCoercionTypes());
            HistoricalIndexLookupStrategyIndex strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, streamViewStreamNum, hashKeys);
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
        }
        CoercionDesc rangeCoercionTypes = CoercionUtil.getCoercionTypesRange(new EventType[]{streamViewType, polledViewType}, 1, rangeIndexes, rangeKeys);
        if (rangeKeys.size() == 1 && hashKeys.size() == 0) {
            Class rangeCoercionType = rangeCoercionTypes.isCoerce() ? rangeCoercionTypes.getCoercionTypes()[0] : null;
            PollResultIndexingStrategySorted indexing = new PollResultIndexingStrategySorted(polledViewStreamNum, polledViewType, rangeIndexes[0], rangeCoercionType);
            HistoricalIndexLookupStrategySorted strategy = new HistoricalIndexLookupStrategySorted(streamViewStreamNum, rangeKeys.get(0));
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
        }
        PollResultIndexingStrategyComposite indexing = new PollResultIndexingStrategyComposite(polledViewStreamNum, polledViewType, hashIndexes, keyCoercionTypes.getCoercionTypes(), rangeIndexes, rangeCoercionTypes.getCoercionTypes());
        HistoricalIndexLookupStrategyComposite strategy = new HistoricalIndexLookupStrategyComposite(streamViewStreamNum, hashKeys, keyCoercionTypes.getCoercionTypes(), rangeKeys, rangeCoercionTypes.getCoercionTypes());
        return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
    }
}

