/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.base;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.join.base.HistoricalDataQueryStrategy;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategyNoIndex;
import com.espertech.esper.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.base.QueryStrategy;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategyNoIndex;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JoinSetComposerPrototypeHistorical2StreamImpl
implements JoinSetComposerPrototype {
    private static final Log log = LogFactory.getLog(JoinSetComposerPrototypeFactory.class);
    private final ExprNode optionalFilterNode;
    private final EventType[] streamTypes;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final int polledViewNum;
    private final int streamViewNum;
    private final boolean isOuterJoin;
    private final ExprNode outerJoinEqualsNode;
    private final Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies;
    private final boolean isAllHistoricalNoSubordinate;
    private final OuterJoinDesc[] outerJoinDescList;

    public JoinSetComposerPrototypeHistorical2StreamImpl(ExprNode optionalFilterNode, EventType[] streamTypes, ExprEvaluatorContext exprEvaluatorContext, int polledViewNum, int streamViewNum, boolean outerJoin, ExprNode outerJoinEqualsNode, Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies, boolean allHistoricalNoSubordinate, OuterJoinDesc[] outerJoinDescList) {
        this.optionalFilterNode = optionalFilterNode;
        this.streamTypes = streamTypes;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.polledViewNum = polledViewNum;
        this.streamViewNum = streamViewNum;
        this.isOuterJoin = outerJoin;
        this.outerJoinEqualsNode = outerJoinEqualsNode;
        this.indexStrategies = indexStrategies;
        this.isAllHistoricalNoSubordinate = allHistoricalNoSubordinate;
        this.outerJoinDescList = outerJoinDescList;
    }

    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget, AgentInstanceContext agentInstanceContext) {
        QueryStrategy[] queryStrategies = new QueryStrategy[this.streamTypes.length];
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.polledViewNum];
        ExprEvaluator outerJoinEqualsNodeEval = this.outerJoinEqualsNode == null ? null : this.outerJoinEqualsNode.getExprEvaluator();
        queryStrategies[this.streamViewNum] = new HistoricalDataQueryStrategy(this.streamViewNum, this.polledViewNum, viewable, this.isOuterJoin, outerJoinEqualsNodeEval, this.indexStrategies.getFirst(), this.indexStrategies.getSecond());
        if (this.isAllHistoricalNoSubordinate) {
            boolean isOuterJoin = false;
            if (this.outerJoinDescList.length > 0) {
                OuterJoinDesc outerJoinDesc = this.outerJoinDescList[0];
                if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && this.polledViewNum == 0) {
                    isOuterJoin = true;
                } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && this.polledViewNum == 1) {
                    isOuterJoin = true;
                }
            }
            viewable = (HistoricalEventViewable)streamViews[this.streamViewNum];
            queryStrategies[this.polledViewNum] = new HistoricalDataQueryStrategy(this.polledViewNum, this.streamViewNum, viewable, isOuterJoin, outerJoinEqualsNodeEval, new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        JoinSetComposerHistoricalImpl composer = new JoinSetComposerHistoricalImpl(null, queryStrategies, streamViews, this.exprEvaluatorContext);
        ExprEvaluator postJoinEval = this.optionalFilterNode == null ? null : this.optionalFilterNode.getExprEvaluator();
        return new JoinSetComposerDesc(composer, postJoinEval);
    }
}

