/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec.base;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.InKeywordTableLookupUtil;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import java.util.Set;

public class InKeywordSingleTableLookupStrategyExpr
implements JoinExecTableLookupStrategy {
    private final PropertyIndexedEventTableSingle index;
    private final int streamNum;
    private final EventBean[] eventsPerStream;
    private final ExprEvaluator[] evaluators;
    private final LookupStrategyDesc lookupStrategyDesc;

    public InKeywordSingleTableLookupStrategyExpr(ExprEvaluator[] evaluators, int streamNum, PropertyIndexedEventTableSingle index, LookupStrategyDesc lookupStrategyDesc) {
        if (index == null) {
            throw new IllegalArgumentException("Unexpected null index received");
        }
        this.index = index;
        this.streamNum = streamNum;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.evaluators = evaluators;
        this.lookupStrategyDesc = lookupStrategyDesc;
    }

    public PropertyIndexedEventTableSingle getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventsPerStream[this.streamNum] = theEvent;
        Set<EventBean> result = InKeywordTableLookupUtil.singleIndexLookup(this.evaluators, this.eventsPerStream, exprEvaluatorContext, this.index);
        return result;
    }

    public String toString() {
        return "IndexedTableLookupStrategyExpr expressions index=(" + this.index + ')';
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.lookupStrategyDesc;
    }
}

