/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.HistoricalDataExecNode;
import com.espertech.esper.epl.join.exec.base.HistoricalTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class HistoricalDataPlanNode
extends QueryPlanNode {
    private final int streamNum;
    private final int rootStreamNum;
    private final int lookupStreamNum;
    private final int numStreams;
    private final ExprNode outerJoinExprNode;

    public HistoricalDataPlanNode(int streamNum, int rootStreamNum, int lookupStreamNum, int numStreams, ExprNode exprNode) {
        this.streamNum = streamNum;
        this.rootStreamNum = rootStreamNum;
        this.lookupStreamNum = lookupStreamNum;
        this.numStreams = numStreams;
        this.outerJoinExprNode = exprNode;
    }

    @Override
    public ExecNode makeExec(String statementName, String statementId, Annotation[] annotations, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexLists, VirtualDWView[] viewExternal, Lock[] tableSecondaryIndexLocks) {
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> pair = historicalStreamIndexLists[this.streamNum].getStrategy(this.lookupStreamNum);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.streamNum];
        return new HistoricalDataExecNode(viewable, pair.getSecond(), pair.getFirst(), this.numStreams, this.streamNum);
    }

    @Override
    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
    }

    public HistoricalTableLookupStrategy makeOuterJoinStategy(Viewable[] streamViews, int pollingStreamNum, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> pair = historicalStreamIndexLists[this.streamNum].getStrategy(pollingStreamNum);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.streamNum];
        return new HistoricalTableLookupStrategy(viewable, pair.getSecond(), pair.getFirst(), this.numStreams, this.streamNum, this.rootStreamNum, this.outerJoinExprNode == null ? null : this.outerJoinExprNode.getExprEvaluator());
    }

    @Override
    protected void print(IndentWriter writer) {
        writer.incrIndent();
        writer.println("HistoricalDataPlanNode streamNum=" + this.streamNum);
    }
}

