/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.exec.base.InKeywordSingleTableLookupStrategyExpr;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import java.util.Collections;

public class InKeywordTableLookupPlanSingleIdx
extends TableLookupPlan {
    private ExprNode[] expressions;

    public InKeywordTableLookupPlanSingleIdx(int lookupStream, int indexedStream, TableLookupIndexReqKey indexNum, ExprNode[] expressions) {
        super(lookupStream, indexedStream, new TableLookupIndexReqKey[]{indexNum});
        this.expressions = expressions;
    }

    public ExprNode[] getExpressions() {
        return this.expressions;
    }

    @Override
    public TableLookupKeyDesc getKeyDescriptor() {
        return new TableLookupKeyDesc(Collections.<QueryGraphValueEntryHashKeyed>emptyList(), Collections.<QueryGraphValueEntryRange>emptyList());
    }

    @Override
    public JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] eventTable, EventType[] eventTypes) {
        PropertyIndexedEventTableSingle single = (PropertyIndexedEventTableSingle)eventTable[0];
        ExprEvaluator[] evaluators = new ExprEvaluator[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            evaluators[i] = this.expressions[i].getExprEvaluator();
        }
        return new InKeywordSingleTableLookupStrategyExpr(evaluators, super.getLookupStream(), single, new LookupStrategyDesc(LookupStrategyType.INKEYWORDSINGLEIDX, ExprNodeUtility.toExpressionStringsMinPrecedence(this.expressions)));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + super.toString() + " keyProperties=" + ExprNodeUtility.toExpressionStringMinPrecedence(this.expressions);
    }
}

