/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.base.ExecNode;
import com.espertech.esper.epl.join.exec.base.NestedIterationExecNode;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class NestedIterationNode
extends QueryPlanNode {
    private final LinkedList<QueryPlanNode> childNodes;
    private final int[] nestingOrder;

    public NestedIterationNode(int[] nestingOrder) {
        this.nestingOrder = nestingOrder;
        this.childNodes = new LinkedList();
        if (nestingOrder.length == 0) {
            throw new IllegalArgumentException("Invalid empty nesting order");
        }
    }

    public final void addChildNode(QueryPlanNode childNode) {
        this.childNodes.add(childNode);
    }

    protected final LinkedList<QueryPlanNode> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public ExecNode makeExec(String statementName, String statementId, Annotation[] annotations, Map<TableLookupIndexReqKey, EventTable>[] indexPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexList, VirtualDWView[] viewExternal, Lock[] tableSecondaryIndexLocks) {
        if (this.childNodes.isEmpty()) {
            throw new IllegalStateException("Zero child nodes for nested iteration");
        }
        NestedIterationExecNode execNode = new NestedIterationExecNode(this.nestingOrder);
        for (QueryPlanNode child : this.childNodes) {
            ExecNode childExec = child.makeExec(statementName, statementId, annotations, indexPerStream, streamTypes, streamViews, historicalStreamIndexList, viewExternal, tableSecondaryIndexLocks);
            execNode.addChildNode(childExec);
        }
        return execNode;
    }

    @Override
    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (QueryPlanNode child : this.childNodes) {
            child.addIndexes(usedIndexes);
        }
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("NestedIterationNode with nesting order " + Arrays.toString(this.nestingOrder));
        indentWriter.incrIndent();
        for (QueryPlanNode child : this.childNodes) {
            child.print(indentWriter);
        }
        indentWriter.decrIndent();
    }
}

