/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import java.util.ArrayList;
import java.util.List;

public class QueryPlanIndexUniqueHelper {
    public static ReducedHashKeys reduceToUniqueIfPossible(String[] hashPropsProvided, Class[] hashCoercionTypes, List<QueryGraphValueEntryHashKeyed> hashFunctions, String[][] hashPropsRequiredPerIndex) {
        if (hashPropsRequiredPerIndex == null || hashPropsRequiredPerIndex.length == 0) {
            return null;
        }
        for (String[] hashPropsRequired : hashPropsRequiredPerIndex) {
            int[] indexes = QueryPlanIndexUniqueHelper.checkSufficientGetAssignment(hashPropsRequired, hashPropsProvided);
            if (indexes == null) continue;
            String[] props = new String[indexes.length];
            Class[] types = new Class[indexes.length];
            ArrayList<QueryGraphValueEntryHashKeyed> functions = new ArrayList<QueryGraphValueEntryHashKeyed>();
            for (int i = 0; i < indexes.length; ++i) {
                props[i] = hashPropsProvided[indexes[i]];
                types[i] = hashCoercionTypes == null ? null : hashCoercionTypes[indexes[i]];
                functions.add(hashFunctions.get(indexes[i]));
            }
            return new ReducedHashKeys(props, types, functions);
        }
        return null;
    }

    public static int[] checkSufficientGetAssignment(String[] hashPropsRequired, String[] hashPropsProvided) {
        if (hashPropsProvided == null || hashPropsRequired == null || hashPropsProvided.length < hashPropsRequired.length) {
            return null;
        }
        for (String required : hashPropsRequired) {
            boolean found = false;
            for (String provided : hashPropsProvided) {
                if (!provided.equals(required)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        int[] indexes = new int[hashPropsRequired.length];
        for (int i = 0; i < indexes.length; ++i) {
            String required;
            int foundIndex = -1;
            required = hashPropsRequired[i];
            for (int j = 0; j < hashPropsProvided.length; ++j) {
                if (!hashPropsProvided[j].equals(required)) continue;
                foundIndex = j;
                break;
            }
            indexes[i] = foundIndex;
        }
        return indexes;
    }

    public static class ReducedHashKeys {
        private final String[] propertyNames;
        private final Class[] coercionTypes;
        private final List<QueryGraphValueEntryHashKeyed> hashKeyFunctions;

        private ReducedHashKeys(String[] propertyNames, Class[] coercionTypes, List<QueryGraphValueEntryHashKeyed> hashKeyFunctions) {
            this.propertyNames = propertyNames;
            this.coercionTypes = coercionTypes;
            this.hashKeyFunctions = hashKeyFunctions;
        }

        public String[] getPropertyNames() {
            return this.propertyNames;
        }

        public Class[] getCoercionTypes() {
            return this.coercionTypes;
        }

        public List<QueryGraphValueEntryHashKeyed> getHashKeyFunctions() {
            return this.hashKeyFunctions;
        }
    }
}

