/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTableFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableCoerceAddFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableCoerceAllFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleCoerceAddFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleCoerceAllFactory;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleFactory;
import com.espertech.esper.epl.join.table.PropertySortedEventTableCoercedFactory;
import com.espertech.esper.epl.join.table.PropertySortedEventTableFactory;
import com.espertech.esper.epl.join.table.UnindexedEventTable;
import com.espertech.esper.util.CollectionUtil;

public class EventTableUtil {
    public static EventTable buildIndex(int indexedStreamNum, QueryPlanIndexItem item, EventType eventType, boolean coerceOnAddOnly, boolean unique, String optionalIndexName) {
        EventTable table;
        String[] indexProps = item.getIndexProps();
        Class[] indexCoercionTypes = EventTableUtil.normalize(item.getOptIndexCoercionTypes());
        String[] rangeProps = item.getRangeProps();
        Class[] rangeCoercionTypes = EventTableUtil.normalize(item.getOptRangeCoercionTypes());
        if (rangeProps == null || rangeProps.length == 0) {
            if (indexProps == null || indexProps.length == 0) {
                table = new UnindexedEventTable(indexedStreamNum);
            } else if (indexProps.length == 1) {
                if (indexCoercionTypes == null || indexCoercionTypes.length == 0) {
                    PropertyIndexedEventTableSingleFactory factory = new PropertyIndexedEventTableSingleFactory(indexedStreamNum, eventType, indexProps[0], unique, optionalIndexName);
                    table = factory.makeEventTables()[0];
                } else if (coerceOnAddOnly) {
                    PropertyIndexedEventTableSingleCoerceAddFactory factory = new PropertyIndexedEventTableSingleCoerceAddFactory(indexedStreamNum, eventType, indexProps[0], indexCoercionTypes[0]);
                    table = factory.makeEventTables()[0];
                } else {
                    PropertyIndexedEventTableSingleCoerceAllFactory factory = new PropertyIndexedEventTableSingleCoerceAllFactory(indexedStreamNum, eventType, indexProps[0], indexCoercionTypes[0]);
                    table = factory.makeEventTables()[0];
                }
            } else if (indexCoercionTypes == null || indexCoercionTypes.length == 0) {
                PropertyIndexedEventTableFactory factory = new PropertyIndexedEventTableFactory(indexedStreamNum, eventType, indexProps, unique, optionalIndexName);
                table = factory.makeEventTables()[0];
            } else if (coerceOnAddOnly) {
                PropertyIndexedEventTableCoerceAddFactory factory = new PropertyIndexedEventTableCoerceAddFactory(indexedStreamNum, eventType, indexProps, indexCoercionTypes);
                table = factory.makeEventTables()[0];
            } else {
                PropertyIndexedEventTableCoerceAllFactory factory = new PropertyIndexedEventTableCoerceAllFactory(indexedStreamNum, eventType, indexProps, indexCoercionTypes);
                table = factory.makeEventTables()[0];
            }
        } else {
            if (rangeProps.length == 1 && (indexProps == null || indexProps.length == 0)) {
                if (rangeCoercionTypes == null) {
                    PropertySortedEventTableFactory factory = new PropertySortedEventTableFactory(indexedStreamNum, eventType, rangeProps[0]);
                    return factory.makeEventTables()[0];
                }
                PropertySortedEventTableCoercedFactory factory = new PropertySortedEventTableCoercedFactory(indexedStreamNum, eventType, rangeProps[0], rangeCoercionTypes[0]);
                return factory.makeEventTables()[0];
            }
            PropertyCompositeEventTableFactory factory = new PropertyCompositeEventTableFactory(indexedStreamNum, eventType, indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes);
            return factory.makeEventTables()[0];
        }
        return table;
    }

    private static Class[] normalize(Class[] types) {
        if (types == null) {
            return null;
        }
        if (CollectionUtil.isAllNullArray(types)) {
            return null;
        }
        return types;
    }
}

