/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.join.base.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.base.JoinSetComposerPrototypeFactory;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexDesc;
import com.espertech.esper.epl.join.table.MultiIndexEventTable;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class HistoricalStreamIndexList {
    private final int historicalStreamNum;
    private final EventType[] typesPerStream;
    private final QueryGraph queryGraph;
    private final TreeSet<Integer> pollingStreams;
    private Map<HistoricalStreamIndexDesc, List<Integer>> indexesUsedByStreams;
    private PollResultIndexingStrategy masterIndexingStrategy;

    public HistoricalStreamIndexList(int historicalStreamNum, EventType[] typesPerStream, QueryGraph queryGraph) {
        this.historicalStreamNum = historicalStreamNum;
        this.typesPerStream = typesPerStream;
        this.queryGraph = queryGraph;
        this.pollingStreams = new TreeSet();
    }

    public void addIndex(int streamViewStreamNum) {
        this.pollingStreams.add(streamViewStreamNum);
    }

    public Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> getStrategy(int streamViewStreamNum) {
        if (this.pollingStreams.size() == 1) {
            return JoinSetComposerPrototypeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum);
        }
        if (this.indexesUsedByStreams == null) {
            this.indexesUsedByStreams = new LinkedHashMap<HistoricalStreamIndexDesc, List<Integer>>();
            for (int pollingStream : this.pollingStreams) {
                QueryGraphValue queryGraphValue = this.queryGraph.getGraphValue(pollingStream, this.historicalStreamNum);
                QueryGraphValuePairHashKeyIndex hashKeyProps = queryGraphValue.getHashKeyProps();
                String[] indexProperties = hashKeyProps.getIndexed();
                Class[] keyTypes = this.getPropertyTypes(hashKeyProps.getKeys());
                Class[] indexTypes = this.getPropertyTypes(this.typesPerStream[this.historicalStreamNum], indexProperties);
                HistoricalStreamIndexDesc desc = new HistoricalStreamIndexDesc(indexProperties, indexTypes, keyTypes);
                List<Integer> usedByStreams = this.indexesUsedByStreams.get(desc);
                if (usedByStreams == null) {
                    usedByStreams = new LinkedList<Integer>();
                    this.indexesUsedByStreams.put(desc, usedByStreams);
                }
                usedByStreams.add(pollingStream);
            }
            if (this.indexesUsedByStreams.size() > 1) {
                final int numIndexes = this.indexesUsedByStreams.size();
                final PollResultIndexingStrategy[] indexingStrategies = new PollResultIndexingStrategy[numIndexes];
                int count = 0;
                for (Map.Entry<HistoricalStreamIndexDesc, List<Integer>> desc : this.indexesUsedByStreams.entrySet()) {
                    int sampleStreamViewStreamNum = desc.getValue().get(0);
                    indexingStrategies[count] = JoinSetComposerPrototypeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[sampleStreamViewStreamNum], this.historicalStreamNum, sampleStreamViewStreamNum).getSecond();
                    ++count;
                }
                final int streamNum = streamViewStreamNum;
                this.masterIndexingStrategy = new PollResultIndexingStrategy(){

                    @Override
                    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache) {
                        EventTable[] tables = new EventTable[numIndexes];
                        for (int i = 0; i < numIndexes; ++i) {
                            tables[i] = indexingStrategies[i].index(pollResult, isActiveCache)[0];
                        }
                        EventTableOrganization organization = new EventTableOrganization(null, false, false, streamNum, null, EventTableOrganization.EventTableOrganizationType.MULTIINDEX);
                        return new EventTable[]{new MultiIndexEventTable(tables, organization)};
                    }

                    @Override
                    public String toQueryPlan() {
                        StringWriter writer = new StringWriter();
                        String delimiter = "";
                        for (PollResultIndexingStrategy strategy : indexingStrategies) {
                            writer.append(delimiter);
                            writer.append(strategy.toQueryPlan());
                            delimiter = ", ";
                        }
                        return this.getClass().getSimpleName() + " " + writer.toString();
                    }
                };
            }
        }
        if (this.indexesUsedByStreams.size() == 1) {
            return JoinSetComposerPrototypeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum);
        }
        int indexUsed = 0;
        boolean found = false;
        for (List<Integer> desc : this.indexesUsedByStreams.values()) {
            if (desc.contains(streamViewStreamNum)) {
                found = true;
                break;
            }
            ++indexUsed;
        }
        if (!found) {
            throw new IllegalStateException("Index not found for use by stream " + streamViewStreamNum);
        }
        final int indexNumber = indexUsed;
        final HistoricalIndexLookupStrategy innerLookupStrategy = JoinSetComposerPrototypeFactory.determineIndexing(this.queryGraph, this.typesPerStream[this.historicalStreamNum], this.typesPerStream[streamViewStreamNum], this.historicalStreamNum, streamViewStreamNum).getFirst();
        HistoricalIndexLookupStrategy lookupStrategy = new HistoricalIndexLookupStrategy(){

            @Override
            public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable[] index, ExprEvaluatorContext context) {
                MultiIndexEventTable multiIndex = (MultiIndexEventTable)index[0];
                EventTable indexToUse = multiIndex.getTables()[indexNumber];
                return innerLookupStrategy.lookup(lookupEvent, new EventTable[]{indexToUse}, context);
            }

            @Override
            public String toQueryPlan() {
                return this.getClass().getSimpleName() + " inner: " + innerLookupStrategy.toQueryPlan();
            }
        };
        return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(lookupStrategy, this.masterIndexingStrategy);
    }

    private Class[] getPropertyTypes(EventType eventType, String[] properties) {
        Class[] types = new Class[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = JavaClassHelper.getBoxedType(eventType.getPropertyType(properties[i]));
        }
        return types;
    }

    private Class[] getPropertyTypes(List<QueryGraphValueEntryHashKeyed> hashKeys) {
        Class[] types = new Class[hashKeys.size()];
        for (int i = 0; i < hashKeys.size(); ++i) {
            types[i] = JavaClassHelper.getBoxedType(hashKeys.get(i).getKeyExpr().getExprEvaluator().getType());
        }
        return types;
    }
}

