/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PropertyIndexedEventTableSingle
implements EventTable {
    protected final EventPropertyGetter propertyGetter;
    protected final EventTableOrganization organization;
    protected final Map<Object, Set<EventBean>> propertyIndex;

    public PropertyIndexedEventTableSingle(EventPropertyGetter propertyGetter, EventTableOrganization organization, boolean allocate) {
        this.propertyGetter = propertyGetter;
        this.organization = organization;
        this.propertyIndex = allocate ? new HashMap<Object, Set<EventBean>>() : null;
    }

    protected Object getKey(EventBean theEvent) {
        return this.propertyGetter.get(theEvent);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent);
            }
        }
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent);
            }
        }
    }

    @Override
    public void add(EventBean[] events) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.add(theEvent);
            }
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.remove(theEvent);
            }
        }
    }

    public Set<EventBean> lookup(Object key) {
        return this.propertyIndex.get(key);
    }

    @Override
    public void add(EventBean theEvent) {
        Object key = this.getKey(theEvent);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            events = new LinkedHashSet<EventBean>();
            this.propertyIndex.put(key, events);
        }
        events.add(theEvent);
    }

    @Override
    public void remove(EventBean theEvent) {
        Object key = this.getKey(theEvent);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            return;
        }
        if (!events.remove(theEvent)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new PropertyIndexedEventTableIterator<Object>(this.propertyIndex);
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.organization.getStreamNum() + " propertyGetter=" + this.propertyGetter;
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.organization;
    }
}

