/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingleUnique;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyIndexedEventTableSingleArrayFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String[] propertyNames;
    protected final boolean unique;
    protected final String optionalIndexName;
    protected final EventPropertyGetter[] propertyGetters;
    private static Log log = LogFactory.getLog(PropertyIndexedEventTableSingleArrayFactory.class);

    public PropertyIndexedEventTableSingleArrayFactory(int streamNum, EventType eventType, String[] propertyNames, boolean unique, String optionalIndexName) {
        this.streamNum = streamNum;
        this.propertyNames = propertyNames;
        this.unique = unique;
        this.optionalIndexName = optionalIndexName;
        this.propertyGetters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            this.propertyGetters[i] = EventBeanUtility.getAssertPropertyGetter(eventType, propertyNames[i]);
        }
    }

    @Override
    public EventTable[] makeEventTables() {
        EventTable[] tables = new EventTable[this.propertyGetters.length];
        if (this.unique) {
            for (int i = 0; i < tables.length; ++i) {
                EventTableOrganization organization = new EventTableOrganization(this.optionalIndexName, this.unique, false, this.streamNum, new String[]{this.propertyNames[i]}, EventTableOrganization.EventTableOrganizationType.HASH);
                tables[i] = new PropertyIndexedEventTableSingleUnique(this.propertyGetters[i], organization);
            }
        } else {
            for (int i = 0; i < tables.length; ++i) {
                EventTableOrganization organization = new EventTableOrganization(this.optionalIndexName, this.unique, false, this.streamNum, new String[]{this.propertyNames[i]}, EventTableOrganization.EventTableOrganizationType.HASH);
                tables[i] = new PropertyIndexedEventTableSingle(this.propertyGetters[i], organization, true);
            }
        }
        return tables;
    }

    @Override
    public Class getEventTableClass() {
        if (this.unique) {
            return PropertyIndexedEventTableSingleUnique.class;
        }
        return PropertyIndexedEventTableSingle.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + (this.unique ? " unique" : " non-unique") + " streamNum=" + this.streamNum + " propertyNames=" + Arrays.toString(this.propertyNames);
    }
}

