/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableFactory;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.event.EventBeanUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertySortedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String propertyName;
    protected final EventPropertyGetter propertyGetter;
    private static Log log = LogFactory.getLog(PropertySortedEventTableFactory.class);

    public PropertySortedEventTableFactory(int streamNum, EventType eventType, String propertyName) {
        this.streamNum = streamNum;
        this.propertyName = propertyName;
        this.propertyGetter = EventBeanUtility.getAssertPropertyGetter(eventType, propertyName);
    }

    @Override
    public EventTable[] makeEventTables() {
        EventTableOrganization organization = new EventTableOrganization(null, false, false, this.streamNum, new String[]{this.propertyName}, EventTableOrganization.EventTableOrganizationType.BTREE);
        return new EventTable[]{new PropertySortedEventTable(this.propertyGetter, organization)};
    }

    @Override
    public Class getEventTableClass() {
        return PropertySortedEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyName=" + this.propertyName;
    }
}

