/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class UnindexedEventTable
implements EventTable {
    private final int streamNum;
    private Set<EventBean> eventSet = new LinkedHashSet<EventBean>();

    public UnindexedEventTable(int streamNum) {
        this.streamNum = streamNum;
    }

    @Override
    public void clear() {
        this.eventSet.clear();
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            Collections.addAll(this.eventSet, newData);
        }
        if (oldData != null) {
            for (EventBean removeEvent : oldData) {
                this.eventSet.remove(removeEvent);
            }
        }
    }

    @Override
    public void add(EventBean[] events) {
        if (events != null) {
            Collections.addAll(this.eventSet, events);
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events != null) {
            for (EventBean removeEvent : events) {
                this.eventSet.remove(removeEvent);
            }
        }
    }

    @Override
    public void add(EventBean event) {
        this.eventSet.add(event);
    }

    @Override
    public void remove(EventBean event) {
        this.eventSet.remove(event);
    }

    @Override
    public boolean isEmpty() {
        return this.eventSet.isEmpty();
    }

    public Set<EventBean> getEventSet() {
        return this.eventSet;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.eventSet.iterator();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum;
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.eventSet.size();
    }

    @Override
    public int getNumKeys() {
        return 0;
    }

    @Override
    public Object getIndex() {
        return this.eventSet;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return new EventTableOrganization(null, false, false, this.streamNum, null, EventTableOrganization.EventTableOrganizationType.UNORGANIZED);
    }
}

