/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAndNamePair;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.lookup.EventTableCreateIndexDesc;
import com.espertech.esper.epl.lookup.EventTableIndexEntryBase;
import com.espertech.esper.epl.lookup.EventTableIndexRepositoryEntry;
import com.espertech.esper.epl.lookup.EventTableIndexUtil;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.spec.CreateIndexItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTableIndexRepository {
    private final List<EventTable> tables = new ArrayList<EventTable>();
    private final Map<IndexMultiKey, EventTableIndexRepositoryEntry> tableIndexesRefCount = new HashMap<IndexMultiKey, EventTableIndexRepositoryEntry>();
    private final HashMap<String, EventTable> explicitIndexes = new HashMap();

    public Pair<IndexMultiKey, EventTableAndNamePair> addExplicitIndexOrReuse(boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName) {
        if (hashProps.isEmpty() && btreeProps.isEmpty()) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        IndexMultiKey indexPropKeyMatch = EventTableIndexUtil.findExactMatchNameAndType(this.tableIndexesRefCount.keySet(), unique, hashProps, btreeProps);
        if (indexPropKeyMatch != null) {
            EventTableIndexRepositoryEntry refTablePair = this.tableIndexesRefCount.get(indexPropKeyMatch);
            return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKeyMatch, new EventTableAndNamePair(refTablePair.getTable(), refTablePair.getOptionalIndexName()));
        }
        return this.addIndex(unique, hashProps, btreeProps, prefilledEvents, indexedType, indexName, false);
    }

    public void addIndex(IndexMultiKey indexMultiKey, EventTableIndexRepositoryEntry entry) {
        this.tableIndexesRefCount.put(indexMultiKey, entry);
        this.tables.add(entry.getTable());
    }

    public List<EventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        this.tables.clear();
        this.tableIndexesRefCount.clear();
    }

    public Pair<IndexMultiKey, EventTableAndNamePair> findTable(Set<String> keyPropertyNames, Set<String> rangePropertyNames, List<IndexHintInstruction> optionalIndexHintInstructions) {
        Pair<IndexMultiKey, EventTableIndexEntryBase> pair = EventTableIndexUtil.findIndexBestAvailable(this.tableIndexesRefCount, keyPropertyNames, rangePropertyNames, optionalIndexHintInstructions);
        if (pair == null) {
            return null;
        }
        EventTable tableFound = ((EventTableIndexRepositoryEntry)pair.getSecond()).getTable();
        return new Pair<IndexMultiKey, EventTableAndNamePair>(pair.getFirst(), new EventTableAndNamePair(tableFound, pair.getSecond().getOptionalIndexName()));
    }

    public IndexMultiKey[] getIndexDescriptors() {
        Set<IndexMultiKey> keySet = this.tableIndexesRefCount.keySet();
        return keySet.toArray(new IndexMultiKey[keySet.size()]);
    }

    public void validateAddExplicitIndex(boolean unique, String indexName, List<CreateIndexItem> columns, EventType eventType, Iterable<EventBean> dataWindowContents) throws ExprValidationException {
        if (this.explicitIndexes.containsKey(indexName)) {
            throw new ExprValidationException("Index by name '" + indexName + "' already exists");
        }
        EventTableCreateIndexDesc desc = EventTableIndexUtil.validateCompileExplicitIndex(unique, columns, eventType);
        Pair<IndexMultiKey, EventTableAndNamePair> pair = this.addExplicitIndexOrReuse(unique, desc.getHashProps(), desc.getBtreeProps(), dataWindowContents, eventType, indexName);
        this.explicitIndexes.put(indexName, pair.getSecond().getEventTable());
    }

    public EventTable getExplicitIndexByName(String indexName) {
        return this.explicitIndexes.get(indexName);
    }

    public EventTable getIndexByDesc(IndexMultiKey indexKey) {
        EventTableIndexRepositoryEntry entry = this.tableIndexesRefCount.get(indexKey);
        if (entry == null) {
            return null;
        }
        return entry.getTable();
    }

    private Pair<IndexMultiKey, EventTableAndNamePair> addIndex(boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Iterable<EventBean> prefilledEvents, EventType indexedType, String indexName, boolean mustCoerce) {
        IndexMultiKey indexPropKey = new IndexMultiKey(unique, hashProps, btreeProps);
        IndexedPropDesc[] indexedPropDescs = hashProps.toArray(new IndexedPropDesc[hashProps.size()]);
        String[] indexProps = IndexedPropDesc.getIndexProperties(indexedPropDescs);
        Class[] indexCoercionTypes = IndexedPropDesc.getCoercionTypes(indexedPropDescs);
        if (!mustCoerce) {
            indexCoercionTypes = null;
        }
        IndexedPropDesc[] rangePropDescs = btreeProps.toArray(new IndexedPropDesc[btreeProps.size()]);
        String[] rangeProps = IndexedPropDesc.getIndexProperties(rangePropDescs);
        Class[] rangeCoercionTypes = IndexedPropDesc.getCoercionTypes(rangePropDescs);
        QueryPlanIndexItem indexItem = new QueryPlanIndexItem(indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes, false);
        EventTable table = EventTableUtil.buildIndex(0, indexItem, indexedType, true, unique, indexName);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = prefilledEvents.iterator();
        while (i$.hasNext()) {
            EventBean prefilledEvent;
            events[0] = prefilledEvent = i$.next();
            table.add(events);
        }
        this.tables.add(table);
        this.tableIndexesRefCount.put(indexPropKey, new EventTableIndexRepositoryEntry(indexName, table));
        return new Pair<IndexMultiKey, EventTableAndNamePair>(indexPropKey, new EventTableAndNamePair(table, indexName));
    }

    public String[] getExplicitIndexNames() {
        Set<String> names = this.explicitIndexes.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void removeIndex(IndexMultiKey index) {
        EventTableIndexRepositoryEntry entry = this.tableIndexesRefCount.remove(index);
        if (entry != null) {
            this.tables.remove(entry.getTable());
            if (entry.getOptionalIndexName() != null) {
                this.explicitIndexes.remove(entry.getOptionalIndexName());
            }
        }
    }

    public IndexMultiKey getIndexByName(String indexName) {
        for (Map.Entry<IndexMultiKey, EventTableIndexRepositoryEntry> entry : this.tableIndexesRefCount.entrySet()) {
            if (!entry.getValue().getOptionalIndexName().equals(indexName)) continue;
            return entry.getKey();
        }
        return null;
    }
}

