/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.StatementAgentInstanceLock;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SubordIndexedTableLookupStrategyLocking
implements SubordTableLookupStrategy {
    private final SubordTableLookupStrategy inner;
    private final StatementAgentInstanceLock statementLock;

    public SubordIndexedTableLookupStrategyLocking(SubordTableLookupStrategy inner, StatementAgentInstanceLock statementLock) {
        this.inner = inner;
        this.statementLock = statementLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        this.statementLock.acquireReadLock();
        try {
            Collection<EventBean> result = this.inner.lookup(events, context);
            if (result != null) {
                ArrayDeque<EventBean> arrayDeque = new ArrayDeque<EventBean>(result);
                return arrayDeque;
            }
            List<EventBean> list = Collections.emptyList();
            return list;
        }
        finally {
            this.statementLock.releaseReadLock();
        }
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.inner.getStrategyDesc();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " inner " + this.inner.toQueryPlan();
    }
}

