/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedExpr;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.EventTableIndexMetadataEntry;
import com.espertech.esper.epl.lookup.EventTableIndexUtil;
import com.espertech.esper.epl.lookup.IndexKeyInfo;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropInKeywordMultiIndex;
import com.espertech.esper.epl.lookup.SubordPropInKeywordSingleIndex;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactoryVDW;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategyFactoryAllFiltered;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategyFactoryAllUnfiltered;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategyFactoryIndexedFiltered;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategyFactoryIndexedUnfiltered;
import com.espertech.esper.epl.lookup.SubordinateQueryIndexDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlanDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerIndexPropDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerIndexPropListPair;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerUtil;
import com.espertech.esper.epl.lookup.SubordinateTableLookupStrategyUtil;
import com.espertech.esper.epl.lookup.SubordinateWMatchExprQueryPlanResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubordinateQueryPlanner {
    public static SubordinateWMatchExprQueryPlanResult planOnExpression(ExprNode joinExpr, EventType filterEventType, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber, ExcludePlanHint excludePlanHint, boolean isVirtualDataWindow, EventTableIndexMetadata indexMetadata, EventType eventTypeIndexed, Set<String> optionalUniqueKeyProps, boolean onlyUseExistingIndexes, String statementName, String statementId, Annotation[] annotations) {
        EventType[] allStreamsZeroIndexed = new EventType[]{eventTypeIndexed, filterEventType};
        EventType[] outerStreams = new EventType[]{filterEventType};
        SubordPropPlan joinedPropPlan = QueryPlanIndexBuilder.getJoinProps(joinExpr, 1, allStreamsZeroIndexed, excludePlanHint);
        if (joinExpr == null && !isVirtualDataWindow) {
            return new SubordinateWMatchExprQueryPlanResult(new SubordWMatchExprLookupStrategyFactoryAllUnfiltered(), null);
        }
        SubordinateQueryPlanDesc queryPlanDesc = SubordinateQueryPlanner.planSubquery(outerStreams, joinedPropPlan, true, false, optionalIndexHint, isIndexShare, subqueryNumber, isVirtualDataWindow, indexMetadata, optionalUniqueKeyProps, onlyUseExistingIndexes, statementName, statementId, annotations);
        if (queryPlanDesc == null) {
            return new SubordinateWMatchExprQueryPlanResult(new SubordWMatchExprLookupStrategyFactoryAllFiltered(joinExpr.getExprEvaluator()), null);
        }
        if (joinExpr == null) {
            return new SubordinateWMatchExprQueryPlanResult(new SubordWMatchExprLookupStrategyFactoryIndexedUnfiltered(queryPlanDesc.getLookupStrategyFactory()), queryPlanDesc.getIndexDescs());
        }
        return new SubordinateWMatchExprQueryPlanResult(new SubordWMatchExprLookupStrategyFactoryIndexedFiltered(joinExpr.getExprEvaluator(), queryPlanDesc.getLookupStrategyFactory()), queryPlanDesc.getIndexDescs());
    }

    public static SubordinateQueryPlanDesc planSubquery(EventType[] outerStreams, SubordPropPlan joinDesc, boolean isNWOnTrigger, boolean forceTableScan, IndexHint optionalIndexHint, boolean indexShare, int subqueryNumber, boolean isVirtualDataWindow, EventTableIndexMetadata indexMetadata, Set<String> optionalUniqueKeyProps, boolean onlyUseExistingIndexes, String statementName, String statementId, Annotation[] annotations) {
        SubordinateQueryIndexDesc[] indexDescs;
        if (isVirtualDataWindow) {
            SubordinateQueryPlannerIndexPropDesc indexProps = SubordinateQueryPlanner.getIndexPropDesc(joinDesc.getHashProps(), joinDesc.getRangeProps());
            SubordTableLookupStrategyFactoryVDW lookupStrategyFactory = new SubordTableLookupStrategyFactoryVDW(statementName, statementId, annotations, outerStreams, Arrays.asList(indexProps.getHashJoinedProps()), new CoercionDesc(false, indexProps.getHashIndexCoercionType()), Arrays.asList(indexProps.getRangeJoinedProps()), new CoercionDesc(false, indexProps.getRangeIndexCoercionType()), isNWOnTrigger, joinDesc, forceTableScan, indexProps.getListPair());
            return new SubordinateQueryPlanDesc(lookupStrategyFactory, null);
        }
        List<SubordPropHashKey> hashKeys = Collections.emptyList();
        CoercionDesc hashKeyCoercionTypes = null;
        List<SubordPropRangeKey> rangeKeys = Collections.emptyList();
        CoercionDesc rangeKeyCoercionTypes = null;
        ExprNode[] inKeywordSingleIdxKeys = null;
        ExprNode inKeywordMultiIdxKey = null;
        if (joinDesc.getInKeywordSingleIndex() != null) {
            SubordPropInKeywordSingleIndex single = joinDesc.getInKeywordSingleIndex();
            SubordPropHashKey keyInfo = new SubordPropHashKey(new QueryGraphValueEntryHashKeyedExpr(single.getExpressions()[0], false), null, single.getCoercionType());
            SubordinateQueryIndexDesc indexDesc = SubordinateQueryPlanner.findOrSuggestIndex(Collections.singletonMap(single.getIndexedProp(), keyInfo), Collections.<String, SubordPropRangeKey>emptyMap(), optionalIndexHint, indexShare, subqueryNumber, indexMetadata, optionalUniqueKeyProps, onlyUseExistingIndexes);
            if (indexDesc == null) {
                return null;
            }
            SubordinateQueryIndexDesc desc = new SubordinateQueryIndexDesc(indexDesc.getIndexKeyInfo(), indexDesc.getIndexName(), indexDesc.getIndexMultiKey(), indexDesc.getQueryPlanIndexItem());
            indexDescs = new SubordinateQueryIndexDesc[]{desc};
            inKeywordSingleIdxKeys = single.getExpressions();
        } else if (joinDesc.getInKeywordMultiIndex() != null) {
            SubordPropInKeywordMultiIndex multi = joinDesc.getInKeywordMultiIndex();
            indexDescs = new SubordinateQueryIndexDesc[multi.getIndexedProp().length];
            for (int i = 0; i < multi.getIndexedProp().length; ++i) {
                SubordPropHashKey keyInfo = new SubordPropHashKey(new QueryGraphValueEntryHashKeyedExpr(multi.getExpression(), false), null, multi.getCoercionType());
                SubordinateQueryIndexDesc indexDesc = SubordinateQueryPlanner.findOrSuggestIndex(Collections.singletonMap(multi.getIndexedProp()[i], keyInfo), Collections.<String, SubordPropRangeKey>emptyMap(), optionalIndexHint, indexShare, subqueryNumber, indexMetadata, optionalUniqueKeyProps, onlyUseExistingIndexes);
                if (indexDesc == null) {
                    return null;
                }
                indexDescs[i] = indexDesc;
            }
            inKeywordMultiIdxKey = multi.getExpression();
        } else {
            SubordinateQueryIndexDesc indexDesc = SubordinateQueryPlanner.findOrSuggestIndex(joinDesc.getHashProps(), joinDesc.getRangeProps(), optionalIndexHint, false, subqueryNumber, indexMetadata, optionalUniqueKeyProps, onlyUseExistingIndexes);
            if (indexDesc == null) {
                return null;
            }
            IndexKeyInfo indexKeyInfo = indexDesc.getIndexKeyInfo();
            hashKeys = indexKeyInfo.getOrderedHashDesc();
            hashKeyCoercionTypes = indexKeyInfo.getOrderedKeyCoercionTypes();
            rangeKeys = indexKeyInfo.getOrderedRangeDesc();
            rangeKeyCoercionTypes = indexKeyInfo.getOrderedRangeCoercionTypes();
            SubordinateQueryIndexDesc desc = new SubordinateQueryIndexDesc(indexDesc.getIndexKeyInfo(), indexDesc.getIndexName(), indexDesc.getIndexMultiKey(), indexDesc.getQueryPlanIndexItem());
            indexDescs = new SubordinateQueryIndexDesc[]{desc};
        }
        if (forceTableScan) {
            return null;
        }
        SubordTableLookupStrategyFactory lookupStrategyFactory = SubordinateTableLookupStrategyUtil.getLookupStrategy(outerStreams, hashKeys, hashKeyCoercionTypes, rangeKeys, rangeKeyCoercionTypes, inKeywordSingleIdxKeys, inKeywordMultiIdxKey, isNWOnTrigger);
        return new SubordinateQueryPlanDesc(lookupStrategyFactory, indexDescs);
    }

    private static SubordinateQueryIndexDesc findOrSuggestIndex(Map<String, SubordPropHashKey> hashProps, Map<String, SubordPropRangeKey> rangeProps, IndexHint optionalIndexHint, boolean isIndexShare, int subqueryNumber, EventTableIndexMetadata indexMetadata, Set<String> optionalUniqueKeyProps, boolean onlyUseExistingIndexes) {
        IndexMultiKey indexMultiKey;
        IndexKeyInfo indexKeyInfo;
        IndexMultiKey indexFoundPair;
        SubordinateQueryPlannerIndexPropDesc indexProps = SubordinateQueryPlanner.getIndexPropDesc(hashProps, rangeProps);
        SubordinateQueryPlannerIndexPropListPair hashedAndBtreeProps = indexProps.getListPair();
        String indexName = null;
        QueryPlanIndexItem planIndexItem = null;
        if (hashedAndBtreeProps.getHashedProps().isEmpty() && hashedAndBtreeProps.getBtreeProps().isEmpty()) {
            return null;
        }
        Pair<IndexMultiKey, String> existing = null;
        Pair<QueryPlanIndexItem, IndexMultiKey> planned = null;
        List<IndexHintInstruction> optionalIndexHintInstructions = null;
        if (optionalIndexHint != null) {
            optionalIndexHintInstructions = optionalIndexHint.getInstructionsSubquery(subqueryNumber);
        }
        if ((indexFoundPair = EventTableIndexUtil.findIndexConsiderTyping(indexMetadata.getIndexes(), hashedAndBtreeProps.getHashedProps(), hashedAndBtreeProps.getBtreeProps(), optionalIndexHintInstructions)) != null) {
            EventTableIndexMetadataEntry hintIndex = indexMetadata.getIndexes().get(indexFoundPair);
            existing = new Pair<IndexMultiKey, String>(indexFoundPair, hintIndex.getOptionalIndexName());
        }
        if (existing == null && !onlyUseExistingIndexes) {
            boolean coerce;
            List<IndexedPropDesc> proposedHashedProps = hashedAndBtreeProps.getHashedProps();
            List<IndexedPropDesc> proposedBtreeProps = hashedAndBtreeProps.getBtreeProps();
            boolean unique = false;
            boolean bl = coerce = !isIndexShare;
            if (optionalUniqueKeyProps != null && !optionalUniqueKeyProps.isEmpty()) {
                ArrayList<IndexedPropDesc> newHashProps = new ArrayList<IndexedPropDesc>();
                for (String uniqueKey : optionalUniqueKeyProps) {
                    boolean found = false;
                    for (IndexedPropDesc hashProp : hashedAndBtreeProps.getHashedProps()) {
                        if (!hashProp.getIndexPropName().equals(uniqueKey)) continue;
                        newHashProps.add(hashProp);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newHashProps = null;
                    break;
                }
                if (newHashProps != null) {
                    proposedHashedProps = newHashProps;
                    proposedBtreeProps = Collections.emptyList();
                    unique = true;
                    coerce = false;
                }
            }
            planned = SubordinateQueryPlanner.planIndex(unique, proposedHashedProps, proposedBtreeProps, coerce);
        }
        if (existing == null && planned == null) {
            return null;
        }
        if (existing != null) {
            indexKeyInfo = SubordinateQueryPlannerUtil.compileIndexKeyInfo((IndexMultiKey)existing.getFirst(), indexProps.getHashIndexPropsProvided(), indexProps.getHashJoinedProps(), indexProps.getRangeIndexPropsProvided(), indexProps.getRangeJoinedProps());
            indexName = existing.getSecond();
            indexMultiKey = existing.getFirst();
        } else {
            indexKeyInfo = SubordinateQueryPlannerUtil.compileIndexKeyInfo((IndexMultiKey)planned.getSecond(), indexProps.getHashIndexPropsProvided(), indexProps.getHashJoinedProps(), indexProps.getRangeIndexPropsProvided(), indexProps.getRangeJoinedProps());
            indexMultiKey = (IndexMultiKey)planned.getSecond();
            planIndexItem = planned.getFirst();
        }
        return new SubordinateQueryIndexDesc(indexKeyInfo, indexName, indexMultiKey, planIndexItem);
    }

    private static SubordinateQueryPlannerIndexPropDesc getIndexPropDesc(Map<String, SubordPropHashKey> hashProps, Map<String, SubordPropRangeKey> rangeProps) {
        String[] hashIndexPropsProvided = new String[hashProps.size()];
        Class[] hashIndexCoercionType = new Class[hashProps.size()];
        SubordPropHashKey[] hashJoinedProps = new SubordPropHashKey[hashProps.size()];
        int count = 0;
        for (Map.Entry<String, SubordPropHashKey> entry : hashProps.entrySet()) {
            hashIndexPropsProvided[count] = entry.getKey();
            hashIndexCoercionType[count] = entry.getValue().getCoercionType();
            hashJoinedProps[count++] = entry.getValue();
        }
        String[] rangeIndexPropsProvided = new String[rangeProps.size()];
        Class[] rangeIndexCoercionType = new Class[rangeProps.size()];
        SubordPropRangeKey[] rangeJoinedProps = new SubordPropRangeKey[rangeProps.size()];
        count = 0;
        for (Map.Entry<String, SubordPropRangeKey> entry : rangeProps.entrySet()) {
            rangeIndexPropsProvided[count] = entry.getKey();
            rangeIndexCoercionType[count] = entry.getValue().getCoercionType();
            rangeJoinedProps[count++] = entry.getValue();
        }
        SubordinateQueryPlannerIndexPropListPair listPair = SubordinateQueryPlannerUtil.toListOfHashedAndBtreeProps(hashIndexPropsProvided, hashIndexCoercionType, rangeIndexPropsProvided, rangeIndexCoercionType);
        return new SubordinateQueryPlannerIndexPropDesc(hashIndexPropsProvided, hashIndexCoercionType, rangeIndexPropsProvided, rangeIndexCoercionType, listPair, hashJoinedProps, rangeJoinedProps);
    }

    private static Pair<QueryPlanIndexItem, IndexMultiKey> planIndex(boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, boolean mustCoerce) {
        IndexMultiKey indexPropKey = new IndexMultiKey(unique, hashProps, btreeProps);
        IndexedPropDesc[] indexedPropDescs = hashProps.toArray(new IndexedPropDesc[hashProps.size()]);
        String[] indexProps = IndexedPropDesc.getIndexProperties(indexedPropDescs);
        Class[] indexCoercionTypes = IndexedPropDesc.getCoercionTypes(indexedPropDescs);
        if (!mustCoerce) {
            indexCoercionTypes = null;
        }
        IndexedPropDesc[] rangePropDescs = btreeProps.toArray(new IndexedPropDesc[btreeProps.size()]);
        String[] rangeProps = IndexedPropDesc.getIndexProperties(rangePropDescs);
        Class[] rangeCoercionTypes = IndexedPropDesc.getCoercionTypes(rangePropDescs);
        QueryPlanIndexItem indexItem = new QueryPlanIndexItem(indexProps, indexCoercionTypes, rangeProps, rangeCoercionTypes, unique);
        return new Pair<QueryPlanIndexItem, IndexMultiKey>(indexItem, indexPropKey);
    }
}

