/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowOnSelectViewFactory;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class NamedWindowOnSelectView
extends NamedWindowOnExprBaseView {
    private final NamedWindowOnSelectViewFactory parent;
    private final ResultSetProcessor resultSetProcessor;
    private EventBean[] lastResult;
    private Set<MultiKey<EventBean>> oldEvents = new HashSet<MultiKey<EventBean>>();
    private final boolean audit;
    private final boolean isDelete;
    private final TableStateInstance tableStateInstanceInsertInto;

    public NamedWindowOnSelectView(SubordWMatchExprLookupStrategy lookupStrategy, NamedWindowRootViewInstance rootView, ExprEvaluatorContext exprEvaluatorContext, NamedWindowOnSelectViewFactory parent, ResultSetProcessor resultSetProcessor, boolean audit, boolean isDelete, TableStateInstance tableStateInstanceInsertInto) {
        super(lookupStrategy, rootView, exprEvaluatorContext);
        this.parent = parent;
        this.resultSetProcessor = resultSetProcessor;
        this.audit = audit;
        this.isDelete = isDelete;
        this.tableStateInstanceInsertInto = tableStateInstanceInsertInto;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] newData;
        this.resultSetProcessor.clear();
        Set<MultiKey<EventBean>> newEvents = NamedWindowOnSelectView.buildJoinResult(triggerEvents, matchingEvents);
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, this.oldEvents, false);
        EventBean[] eventBeanArray = newData = pair != null ? pair.getFirst() : null;
        if (this.parent.isDistinct()) {
            newData = EventBeanUtility.getDistinctByProp(newData, this.parent.getEventBeanReader());
        }
        if (this.tableStateInstanceInsertInto != null) {
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    if (this.audit) {
                        AuditPath.auditInsertInto(this.getExprEvaluatorContext().getEngineURI(), this.getExprEvaluatorContext().getStatementName(), aNewData);
                    }
                    this.tableStateInstanceInsertInto.addEventUnadorned(aNewData);
                }
            }
        } else if (this.parent.getInternalEventRouter() != null && newData != null) {
            for (EventBean aNewData : newData) {
                if (this.audit) {
                    AuditPath.auditInsertInto(this.getExprEvaluatorContext().getEngineURI(), this.getExprEvaluatorContext().getStatementName(), aNewData);
                }
                this.parent.getInternalEventRouter().route(aNewData, this.parent.getStatementHandle(), this.parent.getInternalEventRouteDest(), this.getExprEvaluatorContext(), this.parent.isAddToFront());
            }
        }
        if (newData != null && newData.length > 0 && (this.parent.getStatementResultService().isMakeNatural() || this.parent.getStatementResultService().isMakeSynthetic())) {
            this.updateChildren(newData, null);
        }
        this.lastResult = newData;
        this.resultSetProcessor.clear();
        if (this.isDelete) {
            this.rootView.update(null, matchingEvents);
        }
    }

    public static Set<MultiKey<EventBean>> buildJoinResult(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        LinkedHashSet<MultiKey<EventBean>> events = new LinkedHashSet<MultiKey<EventBean>>();
        for (int i = 0; i < triggerEvents.length; ++i) {
            EventBean triggerEvent = triggerEvents[0];
            if (matchingEvents == null) continue;
            for (int j = 0; j < matchingEvents.length; ++j) {
                EventBean[] eventsPerStream = new EventBean[]{matchingEvents[j], triggerEvent};
                events.add(new MultiKey<EventBean>(eventsPerStream));
            }
        }
        return events;
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new ArrayEventIterator(this.lastResult);
    }
}

