/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.service.resource.StatementResourceService;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class NamedWindowProcessor {
    private final String namedWindowName;
    private final NamedWindowTailView tailView;
    private final NamedWindowRootView rootView;
    private final String contextName;
    private final EventType eventType;
    private final String eplExpression;
    private final String statementName;
    private final boolean isEnableSubqueryIndexShare;
    private final boolean isVirtualDataWindow;
    private final StatementMetricHandle statementMetricHandle;
    private final Set<String> optionalUniqueKeyProps;
    private final String eventTypeAsName;
    private final EventTableIndexMetadata eventTableIndexMetadataRepo = new EventTableIndexMetadata();
    private final StatementResourceService statementResourceService;

    public NamedWindowProcessor(String namedWindowName, NamedWindowService namedWindowService, String contextName, EventType eventType, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, boolean isEnableSubqueryIndexShare, boolean enableQueryPlanLog, MetricReportingService metricReportingService, boolean isBatchingDataWindow, boolean isVirtualDataWindow, StatementMetricHandle statementMetricHandle, Set<String> optionalUniqueKeyProps, String eventTypeAsName, StatementResourceService statementResourceService) {
        this.namedWindowName = namedWindowName;
        this.contextName = contextName;
        this.eventType = eventType;
        this.eplExpression = eplExpression;
        this.statementName = statementName;
        this.isEnableSubqueryIndexShare = isEnableSubqueryIndexShare;
        this.isVirtualDataWindow = isVirtualDataWindow;
        this.statementMetricHandle = statementMetricHandle;
        this.optionalUniqueKeyProps = optionalUniqueKeyProps;
        this.eventTypeAsName = eventTypeAsName;
        this.statementResourceService = statementResourceService;
        this.rootView = new NamedWindowRootView(revisionProcessor, enableQueryPlanLog, metricReportingService, eventType, isBatchingDataWindow, isEnableSubqueryIndexShare, optionalUniqueKeyProps);
        this.tailView = new NamedWindowTailView(eventType, namedWindowService, statementResultService, revisionProcessor, isPrioritized, isBatchingDataWindow);
    }

    public String getEventTypeAsName() {
        return this.eventTypeAsName;
    }

    public synchronized NamedWindowProcessorInstance addInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            return new NamedWindowProcessorInstance(null, this, agentInstanceContext);
        }
        int instanceId = agentInstanceContext.getAgentInstanceId();
        return new NamedWindowProcessorInstance(instanceId, this, agentInstanceContext);
    }

    public NamedWindowProcessorInstance getProcessorInstanceNoContext() {
        StatementResourceHolder holder = this.statementResourceService.getUnpartitioned();
        return holder == null ? null : holder.getNamedWindowProcessorInstance();
    }

    public NamedWindowProcessorInstance getProcessorInstance(int agentInstanceId) {
        StatementResourceHolder holder = this.statementResourceService.getPartitioned(agentInstanceId);
        return holder == null ? null : holder.getNamedWindowProcessorInstance();
    }

    public synchronized Collection<Integer> getProcessorInstancesAll() {
        Set<Integer> keyset = this.statementResourceService.getResourcesPartitioned().keySet();
        return new ArrayDeque<Integer>(keyset);
    }

    public NamedWindowProcessorInstance getProcessorInstance(AgentInstanceContext agentInstanceContext) {
        if (this.contextName == null) {
            StatementResourceHolder holder = this.statementResourceService.getUnpartitioned();
            return holder == null ? null : holder.getNamedWindowProcessorInstance();
        }
        if (agentInstanceContext.getStatementContext().getContextDescriptor() == null) {
            return null;
        }
        if (this.contextName.equals(agentInstanceContext.getStatementContext().getContextDescriptor().getContextName())) {
            StatementResourceHolder holder = this.statementResourceService.getPartitioned(agentInstanceContext.getAgentInstanceId());
            return holder == null ? null : holder.getNamedWindowProcessorInstance();
        }
        return null;
    }

    public String getContextName() {
        return this.contextName;
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        if (this.contextName != null) {
            ContextDescriptor contextDescriptor = consumerDesc.getAgentInstanceContext().getStatementContext().getContextDescriptor();
            if (contextDescriptor != null && this.contextName.equals(contextDescriptor.getContextName())) {
                StatementResourceHolder holder = this.statementResourceService.getPartitioned(consumerDesc.getAgentInstanceContext().getAgentInstanceId());
                return holder.getNamedWindowProcessorInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
            }
            return this.tailView.addConsumer(consumerDesc);
        }
        return this.statementResourceService.getResourcesUnpartitioned().getNamedWindowProcessorInstance().getTailViewInstance().addConsumer(consumerDesc, isSubselect);
    }

    public boolean isVirtualDataWindow() {
        return this.isVirtualDataWindow;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    public NamedWindowRootView getRootView() {
        return this.rootView;
    }

    public EventType getNamedWindowType() {
        return this.eventType;
    }

    public String getEplExpression() {
        return this.eplExpression;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public void destroy() {
    }

    public boolean isEnableSubqueryIndexShare() {
        return this.isEnableSubqueryIndexShare;
    }

    public StatementMetricHandle getCreateNamedWindowMetricsHandle() {
        return this.statementMetricHandle;
    }

    public String getNamedWindowName() {
        return this.namedWindowName;
    }

    public String[][] getUniqueIndexes(NamedWindowProcessorInstance processorInstance) {
        ArrayList<String[]> unique = null;
        if (processorInstance != null) {
            IndexMultiKey[] indexDescriptors;
            for (IndexMultiKey index : indexDescriptors = processorInstance.getIndexDescriptors()) {
                if (!index.isUnique()) continue;
                String[] uniqueKeys = IndexedPropDesc.getIndexProperties(index.getHashIndexedProps());
                if (unique == null) {
                    unique = new ArrayList();
                }
                unique.add(uniqueKeys);
            }
        }
        if (this.optionalUniqueKeyProps != null) {
            if (unique == null) {
                unique = new ArrayList<String[]>();
            }
            unique.add(this.optionalUniqueKeyProps.toArray(new String[this.optionalUniqueKeyProps.size()]));
        }
        if (unique == null) {
            return null;
        }
        return (String[][])unique.toArray((T[])new String[unique.size()][]);
    }

    public Set<String> getOptionalUniqueKeyProps() {
        return this.optionalUniqueKeyProps;
    }

    public EventTableIndexMetadata getEventTableIndexMetadataRepo() {
        return this.eventTableIndexMetadataRepo;
    }

    public void removeAllInstanceIndexes(IndexMultiKey index) {
        if (this.contextName == null) {
            StatementResourceHolder holder = this.statementResourceService.getUnpartitioned();
            if (holder != null && holder.getNamedWindowProcessorInstance() != null) {
                holder.getNamedWindowProcessorInstance().removeIndex(index);
            }
        } else {
            for (Map.Entry<Integer, StatementResourceHolder> entry : this.statementResourceService.getResourcesPartitioned().entrySet()) {
                if (entry.getValue().getNamedWindowProcessorInstance() == null) continue;
                entry.getValue().getNamedWindowProcessorInstance().removeIndex(index);
            }
        }
    }

    public void validateAddIndex(String statementName, String indexName, IndexMultiKey imk) throws ExprValidationException {
        this.eventTableIndexMetadataRepo.addIndex(false, imk, indexName, statementName, true);
    }

    public void removeIndexReferencesStmtMayRemoveIndex(IndexMultiKey imk, String finalStatementName) {
        boolean last = this.eventTableIndexMetadataRepo.removeIndexReference(imk, finalStatementName);
        if (last) {
            this.eventTableIndexMetadataRepo.removeIndex(imk);
            this.removeAllInstanceIndexes(imk);
        }
    }

    private void checkAlreadyAllocated(StatementResourceHolder holder) {
        if (holder.getNamedWindowProcessorInstance() != null) {
            throw new RuntimeException("Failed to allocated processor instance: already allocated and not released");
        }
    }
}

