/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;

public class NamedWindowProcessorInstance {
    private final Integer agentInstanceId;
    private final NamedWindowTailViewInstance tailViewInstance;
    private final NamedWindowRootViewInstance rootViewInstance;

    public NamedWindowProcessorInstance(Integer agentInstanceId, NamedWindowProcessor processor, AgentInstanceContext agentInstanceContext) {
        this.agentInstanceId = agentInstanceId;
        this.rootViewInstance = new NamedWindowRootViewInstance(processor.getRootView(), agentInstanceContext);
        this.tailViewInstance = new NamedWindowTailViewInstance(this.rootViewInstance, processor.getTailView(), agentInstanceContext);
        this.rootViewInstance.setDataWindowContents(this.tailViewInstance);
    }

    public NamedWindowTailViewInstance getTailViewInstance() {
        return this.tailViewInstance;
    }

    public NamedWindowRootViewInstance getRootViewInstance() {
        return this.rootViewInstance;
    }

    public long getCountDataWindow() {
        return this.tailViewInstance.getNumberOfEvents();
    }

    public void destroy() {
        this.tailViewInstance.destroy();
        this.rootViewInstance.destroy();
    }

    public IndexMultiKey[] getIndexDescriptors() {
        return this.rootViewInstance.getIndexes();
    }

    public Integer getAgentInstanceId() {
        return this.agentInstanceId;
    }

    public StatementAgentInstancePostLoad getPostLoad() {
        return new StatementAgentInstancePostLoad(){

            @Override
            public void executePostLoad() {
                NamedWindowProcessorInstance.this.rootViewInstance.postLoad();
            }

            @Override
            public void acceptIndexVisitor(StatementAgentInstancePostLoadIndexVisitor visitor) {
                NamedWindowProcessorInstance.this.rootViewInstance.visitIndexes(visitor);
            }
        };
    }

    public void removeIndex(IndexMultiKey index) {
        this.rootViewInstance.getIndexRepository().removeIndex(index);
    }
}

