/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoadIndexVisitor;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.fafquery.FireAndForgetQueryExec;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.SubordWMatchExprLookupStrategy;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.epl.spec.CreateIndexItem;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamedWindowRootViewInstance
extends ViewSupport {
    private final NamedWindowRootView rootView;
    private final AgentInstanceContext agentInstanceContext;
    private final EventTableIndexRepository indexRepository;
    private final Map<SubordWMatchExprLookupStrategy, EventTable[]> tablePerMultiLookup;
    private Iterable<EventBean> dataWindowContents;

    public NamedWindowRootViewInstance(NamedWindowRootView rootView, AgentInstanceContext agentInstanceContext) {
        this.rootView = rootView;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new EventTableIndexRepository();
        this.tablePerMultiLookup = new HashMap<SubordWMatchExprLookupStrategy, EventTable[]>();
    }

    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    public IndexMultiKey[] getIndexes() {
        return this.indexRepository.getIndexDescriptors();
    }

    public Iterable<EventBean> getDataWindowContents() {
        return this.dataWindowContents;
    }

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().removeOldData(oldData, this.indexRepository);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                table.remove(oldData);
            }
        }
    }

    public void addNewData(EventBean[] newData) {
        if (this.rootView.getRevisionProcessor() == null) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(newData);
            }
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.rootView.getRevisionProcessor() != null) {
            this.rootView.getRevisionProcessor().onUpdate(newData, oldData, this, this.indexRepository);
        } else {
            for (EventTable table : this.indexRepository.getTables()) {
                if (!this.rootView.isChildBatching()) continue;
                table.add(newData);
            }
            this.updateChildren(newData, oldData);
        }
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
    }

    @Override
    public EventType getEventType() {
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        this.tablePerMultiLookup.clear();
    }

    public Collection<EventBean> snapshot(FilterSpecCompiled optionalFilter, Annotation[] annotations) {
        VirtualDWView virtualDataWindow = null;
        if (this.isVirtualDataWindow()) {
            virtualDataWindow = this.getVirtualDataWindow();
        }
        return FireAndForgetQueryExec.snapshot(optionalFilter, annotations, virtualDataWindow, this.indexRepository, this.rootView.isQueryPlanLogging(), NamedWindowRootView.getQueryPlanLog(), this.rootView.getEventType().getName(), this.agentInstanceContext);
    }

    public synchronized void addExplicitIndex(boolean unique, String indexName, List<CreateIndexItem> columns) throws ExprValidationException {
        this.indexRepository.validateAddExplicitIndex(unique, indexName, columns, this.rootView.getEventType(), this.dataWindowContents);
    }

    public boolean isVirtualDataWindow() {
        return this.getViews()[0] instanceof VirtualDWView;
    }

    public VirtualDWView getVirtualDataWindow() {
        if (!this.isVirtualDataWindow()) {
            return null;
        }
        return (VirtualDWView)((Object)this.getViews()[0]);
    }

    public void postLoad() {
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = this.dataWindowContents.iterator();
        while (i$.hasNext()) {
            EventBean event;
            events[0] = event = i$.next();
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(events);
            }
        }
    }

    public void visitIndexes(StatementAgentInstancePostLoadIndexVisitor visitor) {
        visitor.visit(this.indexRepository.getTables());
    }

    public boolean isQueryPlanLogging() {
        return this.rootView.isQueryPlanLogging();
    }
}

