/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.client.hook.VirtualDataWindowEventConsumerAdd;
import com.espertech.esper.client.hook.VirtualDataWindowEventConsumerRemove;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.named.NamedWindowConsumerCallback;
import com.espertech.esper.epl.named.NamedWindowConsumerDesc;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.epl.named.NamedWindowTailView;
import com.espertech.esper.epl.named.NamedWindowUtil;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateHelper;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NamedWindowTailViewInstance
extends ViewSupport
implements Iterable<EventBean> {
    private final NamedWindowRootViewInstance rootViewInstance;
    private final NamedWindowTailView tailView;
    private final AgentInstanceContext agentInstanceContext;
    private volatile Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersInContext;
    private volatile long numberOfEvents;

    public NamedWindowTailViewInstance(NamedWindowRootViewInstance rootViewInstance, NamedWindowTailView tailView, AgentInstanceContext agentInstanceContext) {
        this.rootViewInstance = rootViewInstance;
        this.tailView = tailView;
        this.agentInstanceContext = agentInstanceContext;
        this.consumersInContext = NamedWindowUtil.createConsumerMap(tailView.isPrioritized());
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            this.rootViewInstance.removeOldData(oldData);
            this.numberOfEvents -= (long)oldData.length;
        }
        if (newData != null && !this.tailView.isParentBatchWindow()) {
            this.rootViewInstance.addNewData(newData);
        }
        if (newData != null) {
            this.numberOfEvents += (long)newData.length;
        }
        if (this.tailView.getStatementResultService().isMakeNatural() || this.tailView.getStatementResultService().isMakeSynthetic()) {
            this.updateChildren(newData, oldData);
        }
        if (!this.consumersInContext.isEmpty() || !this.tailView.getConsumersNonContext().isEmpty()) {
            NamedWindowDeltaData delta = new NamedWindowDeltaData(newData, oldData);
            this.tailView.getNamedWindowService().addDispatch(delta, this.consumersInContext);
            this.tailView.getNamedWindowService().addDispatch(delta, this.tailView.getConsumersNonContext());
        }
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        List<NamedWindowConsumerView> viewsPerStatements;
        NamedWindowConsumerCallback consumerCallback = new NamedWindowConsumerCallback(){

            @Override
            public Iterator<EventBean> getIterator() {
                return NamedWindowTailViewInstance.this.iterator();
            }

            @Override
            public void stopped(NamedWindowConsumerView namedWindowConsumerView) {
                NamedWindowTailViewInstance.this.removeConsumer(namedWindowConsumerView);
            }
        };
        boolean audit = AuditEnum.STREAM.getAudit(consumerDesc.getAgentInstanceContext().getStatementContext().getAnnotations()) != null;
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(ExprNodeUtility.getEvaluators(consumerDesc.getFilterList()), consumerDesc.getOptPropertyEvaluator(), this.tailView.getEventType(), consumerCallback, consumerDesc.getAgentInstanceContext(), audit);
        VirtualDWView virtualDWView = this.rootViewInstance.getVirtualDataWindow();
        if (virtualDWView != null) {
            virtualDWView.getVirtualDataWindow().handleEvent(new VirtualDataWindowEventConsumerAdd(this.tailView.getEventType().getName(), consumerView, consumerDesc.getAgentInstanceContext().getStatementName(), consumerDesc.getAgentInstanceContext().getAgentInstanceId(), ExprNodeUtility.toArray(consumerDesc.getFilterList()), this.agentInstanceContext));
        }
        if ((viewsPerStatements = this.consumersInContext.get(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle())) == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
            newConsumers.putAll(this.consumersInContext);
            newConsumers.put(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), viewsPerStatements);
            this.consumersInContext = newConsumers;
        }
        if (isSubselect) {
            viewsPerStatements.add(0, consumerView);
        } else {
            viewsPerStatements.add(consumerView);
        }
        return consumerView;
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        VirtualDWView virtualDWView;
        EPStatementAgentInstanceHandle handleRemoved = null;
        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : this.consumersInContext.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
            newConsumers.putAll(this.consumersInContext);
            newConsumers.remove(handleRemoved);
            this.consumersInContext = newConsumers;
        }
        if ((virtualDWView = this.rootViewInstance.getVirtualDataWindow()) != null && handleRemoved != null) {
            virtualDWView.getVirtualDataWindow().handleEvent(new VirtualDataWindowEventConsumerRemove(this.tailView.getEventType().getName(), namedWindowConsumerView, handleRemoved.getStatementHandle().getStatementName(), handleRemoved.getAgentInstanceId()));
        }
    }

    @Override
    public EventType getEventType() {
        return this.tailView.getEventType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EventBean> iterator() {
        if (this.tailView.getRevisionProcessor() != null) {
            Collection<EventBean> coll = this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
            return coll.iterator();
        }
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                Iterator<EventBean> iterator = CollectionUtil.NULL_EVENT_ITERATOR;
                return iterator;
            }
            ArrayList<EventBean> list = new ArrayList<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayEventIterator arrayEventIterator = new ArrayEventIterator(list.toArray(new EventBean[list.size()]));
            return arrayEventIterator;
        }
        finally {
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EventBean> snapshot(FilterSpecCompiled filter, Annotation[] annotations) {
        if (this.tailView.getRevisionProcessor() != null) {
            return this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
        }
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Collection<EventBean> collection = this.snapshotNoLock(filter, annotations);
            return collection;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBean[] snapshotUpdate(FilterSpecCompiled filter, ExprNode optionalWhereClause, EventBeanUpdateHelper updateHelper, Annotation[] annotations) {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Collection<EventBean> events = this.snapshotNoLockWithFilter(filter, annotations, optionalWhereClause, this.agentInstanceContext);
            if (events.isEmpty()) {
                EventBean[] eventBeanArray = CollectionUtil.EVENTBEANARRAY_EMPTY;
                return eventBeanArray;
            }
            EventBean[] eventsPerStream = new EventBean[3];
            EventBean[] updated = new EventBean[events.size()];
            int count = 0;
            for (EventBean event : events) {
                updated[count++] = updateHelper.updateWCopy(event, eventsPerStream, this.agentInstanceContext);
            }
            EventBean[] deleted = events.toArray(new EventBean[events.size()]);
            this.rootViewInstance.update(updated, deleted);
            EventBean[] eventBeanArray = updated;
            return eventBeanArray;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBean[] snapshotDelete(FilterSpecCompiled filter, ExprNode filterExpr, Annotation[] annotations) {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Collection<EventBean> events = this.snapshotNoLockWithFilter(filter, annotations, filterExpr, this.agentInstanceContext);
            if (events.isEmpty()) {
                EventBean[] eventBeanArray = CollectionUtil.EVENTBEANARRAY_EMPTY;
                return eventBeanArray;
            }
            EventBean[] eventsDeleted = events.toArray(new EventBean[events.size()]);
            this.rootViewInstance.update(null, eventsDeleted);
            EventBean[] eventBeanArray = eventsDeleted;
            return eventBeanArray;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    public Collection<EventBean> snapshotNoLock(FilterSpecCompiled filter, Annotation[] annotations) {
        if (this.tailView.getRevisionProcessor() != null) {
            return this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
        }
        Collection<EventBean> indexedResult = this.rootViewInstance.snapshot(filter, annotations);
        if (indexedResult != null) {
            return indexedResult;
        }
        Iterator<EventBean> it = this.parent.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public Collection<EventBean> snapshotNoLockWithFilter(FilterSpecCompiled filter, Annotation[] annotations, ExprNode filterExpr, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.tailView.getRevisionProcessor() != null) {
            return this.tailView.getRevisionProcessor().getSnapshot(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), this.parent);
        }
        Collection<EventBean> indexedResult = this.rootViewInstance.snapshot(filter, annotations);
        if (indexedResult != null) {
            if (indexedResult.isEmpty()) {
                return indexedResult;
            }
            if (filterExpr == null) {
                return indexedResult;
            }
            ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(indexedResult.size(), 16));
            ExprNodeUtility.applyFilterExpressionIterable(indexedResult.iterator(), filterExpr.getExprEvaluator(), exprEvaluatorContext, deque);
            return deque;
        }
        Iterator<EventBean> it = this.parent.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
        if (filterExpr != null) {
            ExprNodeUtility.applyFilterExpressionIterable(it, filterExpr.getExprEvaluator(), this.agentInstanceContext, list);
        } else {
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        return list;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public void destroy() {
        this.consumersInContext = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    private void releaseTableLocks(AgentInstanceContext agentInstanceContext) {
        agentInstanceContext.getStatementContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
    }
}

