/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTExprHelper;
import com.espertech.esper.epl.spec.GroupByClauseElement;
import com.espertech.esper.epl.spec.GroupByClauseElementCombinedExpr;
import com.espertech.esper.epl.spec.GroupByClauseElementExpr;
import com.espertech.esper.epl.spec.GroupByClauseElementGroupingSet;
import com.espertech.esper.epl.spec.GroupByClauseElementRollupOrCube;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.Tree;

public class ASTGroupByHelper {
    public static void walkGroupBy(EsperEPL2GrammarParser.GroupByListExprContext ctx, Map<Tree, ExprNode> astExprNodeMap, List<GroupByClauseElement> groupByExpressions) {
        List<EsperEPL2GrammarParser.GroupByListChoiceContext> choices = ctx.groupByListChoice();
        for (EsperEPL2GrammarParser.GroupByListChoiceContext choice : choices) {
            GroupByClauseElement element = ASTGroupByHelper.walkChoice(choice, astExprNodeMap);
            groupByExpressions.add(element);
        }
    }

    private static GroupByClauseElement walkChoice(EsperEPL2GrammarParser.GroupByListChoiceContext choice, Map<Tree, ExprNode> astExprNodeMap) {
        if (choice.e1 != null) {
            ExprNode expr = ASTExprHelper.exprCollectSubNodes((Tree)choice.e1, 0, astExprNodeMap).get(0);
            return new GroupByClauseElementExpr(expr);
        }
        if (choice.groupByCubeOrRollup() != null) {
            return ASTGroupByHelper.walkCubeOrRollup(choice.groupByCubeOrRollup(), astExprNodeMap);
        }
        return ASTGroupByHelper.walkGroupingSets(choice.groupByGroupingSets().groupBySetsChoice(), astExprNodeMap);
    }

    private static GroupByClauseElement walkCubeOrRollup(EsperEPL2GrammarParser.GroupByCubeOrRollupContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        boolean cube = ctx.CUBE() != null;
        List<GroupByClauseElement> combinables = ASTGroupByHelper.walkCombinables(ctx.groupByCombinableExpr(), astExprNodeMap);
        return new GroupByClauseElementRollupOrCube(cube, combinables);
    }

    private static List<GroupByClauseElement> walkCombinables(List<EsperEPL2GrammarParser.GroupByCombinableExprContext> ctxs, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<GroupByClauseElement> elements = new ArrayList<GroupByClauseElement>();
        for (EsperEPL2GrammarParser.GroupByCombinableExprContext ctx : ctxs) {
            elements.add(ASTGroupByHelper.walkCombinable(ctx, astExprNodeMap));
        }
        return elements;
    }

    private static GroupByClauseElement walkCombinable(EsperEPL2GrammarParser.GroupByCombinableExprContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        if (ctx.e1 != null && ctx.LPAREN() == null) {
            ExprNode expr = ASTExprHelper.exprCollectSubNodes((Tree)ctx.e1, 0, astExprNodeMap).get(0);
            return new GroupByClauseElementExpr(expr);
        }
        List<ExprNode> combined = ASTExprHelper.exprCollectSubNodes((Tree)ctx, 0, astExprNodeMap);
        return new GroupByClauseElementCombinedExpr(combined);
    }

    private static GroupByClauseElementGroupingSet walkGroupingSets(List<EsperEPL2GrammarParser.GroupBySetsChoiceContext> ctxs, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<GroupByClauseElement> elements = new ArrayList<GroupByClauseElement>();
        for (EsperEPL2GrammarParser.GroupBySetsChoiceContext ctx : ctxs) {
            if (ctx.groupByCubeOrRollup() != null) {
                elements.add(ASTGroupByHelper.walkCubeOrRollup(ctx.groupByCubeOrRollup(), astExprNodeMap));
                continue;
            }
            elements.add(ASTGroupByHelper.walkCombinable(ctx.groupByCombinableExpr(), astExprNodeMap));
        }
        return new GroupByClauseElementGroupingSet(elements);
    }
}

