/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.ContextDescriptor;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.declexpr.ExprDeclaredHelper;
import com.espertech.esper.epl.declexpr.ExprDeclaredNodeImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredService;
import com.espertech.esper.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.dot.ExprDotNode;
import com.espertech.esper.epl.expression.funcs.ExprMinMaxRowNode;
import com.espertech.esper.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.epl.expression.methodagg.ExprMinMaxAggrNode;
import com.espertech.esper.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTAggregationHelper;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTExprHelper;
import com.espertech.esper.epl.parse.ASTTableExprHelper;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.script.ExprNodeScript;
import com.espertech.esper.epl.spec.ExpressionDeclDesc;
import com.espertech.esper.epl.spec.ExpressionScriptProvided;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionFactory;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.util.LazyAllocatedMap;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.Tree;

public class ASTLibFunctionHelper {
    public static List<ExprChainedSpec> getLibFuncChain(List<EsperEPL2GrammarParser.LibFunctionNoClassContext> ctxs, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<ExprChainedSpec> chained = new ArrayList<ExprChainedSpec>(ctxs.size());
        for (EsperEPL2GrammarParser.LibFunctionNoClassContext ctx : ctxs) {
            ExprChainedSpec chainSpec = ASTLibFunctionHelper.getLibFunctionChainSpec(ctx, astExprNodeMap);
            chained.add(chainSpec);
        }
        return chained;
    }

    public static ExprChainedSpec getLibFunctionChainSpec(EsperEPL2GrammarParser.LibFunctionNoClassContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        String methodName = ASTConstantHelper.removeTicks(ctx.funcIdentChained().getText());
        List<ExprNode> parameters = ASTLibFunctionHelper.getExprNodesLibFunc(ctx.libFunctionArgs(), astExprNodeMap);
        boolean property = ctx.l == null;
        return new ExprChainedSpec(methodName, parameters, property);
    }

    public static List<ExprNode> getExprNodesLibFunc(EsperEPL2GrammarParser.LibFunctionArgsContext ctx, Map<Tree, ExprNode> astExprNodeMap) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        List<EsperEPL2GrammarParser.LibFunctionArgItemContext> args = ctx.libFunctionArgItem();
        if (args == null || args.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExprNode> parameters = new ArrayList<ExprNode>(args.size());
        for (EsperEPL2GrammarParser.LibFunctionArgItemContext arg : args) {
            if (arg.expressionLambdaDecl() != null) {
                List<String> lambdaparams = ASTLibFunctionHelper.getLambdaGoesParams(arg.expressionLambdaDecl());
                ExprLambdaGoesNode goes = new ExprLambdaGoesNode(lambdaparams);
                ExprNode lambdaExpr = ASTExprHelper.exprCollectSubNodes((Tree)arg.expressionWithNamed(), 0, astExprNodeMap).get(0);
                goes.addChildNode(lambdaExpr);
                parameters.add(goes);
                continue;
            }
            ExprNode parameter = ASTExprHelper.exprCollectSubNodes((Tree)arg.expressionWithNamed(), 0, astExprNodeMap).get(0);
            parameters.add(parameter);
        }
        return parameters;
    }

    protected static List<String> getLambdaGoesParams(EsperEPL2GrammarParser.ExpressionLambdaDeclContext ctx) {
        List<String> parameters;
        if (ctx.i != null) {
            parameters = new ArrayList<String>(1);
            parameters.add(ctx.i.getText());
        } else {
            parameters = ASTUtil.getIdentList(ctx.columnList());
        }
        return parameters;
    }

    public static void handleLibFunc(CommonTokenStream tokenStream, EsperEPL2GrammarParser.LibFunctionContext ctx, ConfigurationInformation configurationInformation, EngineImportService engineImportService, Map<Tree, ExprNode> astExprNodeMap, LazyAllocatedMap<ConfigurationPlugInAggregationMultiFunction, PlugInAggregationMultiFunctionFactory> plugInAggregations, String engineURI, ExpressionDeclDesc expressionDeclarations, ExprDeclaredService exprDeclaredService, List<ExpressionScriptProvided> scriptExpressions, ContextDescriptor contextDescriptor, TableService tableService, StatementSpecRaw statementSpec, VariableService variableService) {
        ExprNode aggregationNode;
        boolean distinct;
        ASTLibModel model = ASTLibFunctionHelper.getModel(ctx, tokenStream);
        boolean duckType = configurationInformation.getEngineDefaults().getExpression().isDuckTyping();
        boolean udfCache = configurationInformation.getEngineDefaults().getExpression().isUdfCache();
        if (model.chainElements.size() == 1 && model.optionalClassIdent != null && ASTTableExprHelper.checkTableNameGetExprForProperty(tableService, model.optionalClassIdent) == null) {
            ExprChainedSpec chainSpec = ASTLibFunctionHelper.getLibFunctionChainSpec((ASTLibModelChainElement)model.chainElements.get(0), astExprNodeMap);
            ExprDeclaredNodeImpl declaredNode = ExprDeclaredHelper.getExistsDeclaredExpr(model.optionalClassIdent, Collections.<ExprNode>emptyList(), expressionDeclarations.getExpressions(), exprDeclaredService, contextDescriptor);
            if (declaredNode != null) {
                ExprDotNode exprNode = new ExprDotNode(Collections.singletonList(chainSpec), duckType, udfCache);
                exprNode.addChildNode(declaredNode);
                ASTExprHelper.exprCollectAddSubNodesAddParentNode(exprNode, (Tree)ctx, astExprNodeMap);
                return;
            }
            ArrayList<ExprChainedSpec> chain = new ArrayList<ExprChainedSpec>(2);
            chain.add(new ExprChainedSpec(model.getOptionalClassIdent(), Collections.<ExprNode>emptyList(), true));
            chain.add(chainSpec);
            ExprDotNode dotNode = new ExprDotNode(chain, configurationInformation.getEngineDefaults().getExpression().isDuckTyping(), configurationInformation.getEngineDefaults().getExpression().isUdfCache());
            if (dotNode.isVariableOp(variableService)) {
                statementSpec.setHasVariables(true);
            }
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(dotNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        ExprNode singleRowExtNode = engineImportService.resolveSingleRowExtendedBuiltin(model.getChainElements().get(0).getFuncName());
        if (singleRowExtNode != null) {
            if (model.chainElements.size() == 1) {
                ASTExprHelper.exprCollectAddSubNodesAddParentNode(singleRowExtNode, (Tree)ctx, astExprNodeMap);
                return;
            }
            ArrayList<ExprChainedSpec> spec = new ArrayList<ExprChainedSpec>();
            EsperEPL2GrammarParser.LibFunctionArgsContext firstArgs = model.getChainElements().get(0).getArgs();
            List<ExprNode> childExpressions = ASTLibFunctionHelper.getExprNodesLibFunc(firstArgs, astExprNodeMap);
            singleRowExtNode.addChildNodes(childExpressions);
            ASTLibFunctionHelper.addChainRemainderFromOffset(model.getChainElements(), 1, spec, astExprNodeMap);
            ExprDotNode dotNode = new ExprDotNode(spec, configurationInformation.getEngineDefaults().getExpression().isDuckTyping(), configurationInformation.getEngineDefaults().getExpression().isUdfCache());
            dotNode.addChildNode(singleRowExtNode);
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(dotNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        try {
            String firstFunction = model.getChainElements().get(0).getFuncName();
            boolean firstFunctionIsProperty = !model.getChainElements().get(0).isHasLeftParen();
            Pair<Class, EngineImportSingleRowDesc> classMethodPair = engineImportService.resolveSingleRow(firstFunction);
            ArrayList<ExprChainedSpec> spec = new ArrayList<ExprChainedSpec>();
            EsperEPL2GrammarParser.LibFunctionArgsContext firstArgs = model.getChainElements().get(0).getArgs();
            List<ExprNode> childExpressions = ASTLibFunctionHelper.getExprNodesLibFunc(firstArgs, astExprNodeMap);
            spec.add(new ExprChainedSpec(classMethodPair.getSecond().getMethodName(), childExpressions, firstFunctionIsProperty));
            ASTLibFunctionHelper.addChainRemainderFromOffset(model.getChainElements(), 1, spec, astExprNodeMap);
            ExprPlugInSingleRowNode plugin = new ExprPlugInSingleRowNode(firstFunction, classMethodPair.getFirst(), spec, classMethodPair.getSecond());
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(plugin, (Tree)ctx, astExprNodeMap);
            return;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving single-row function: " + e.getMessage(), e);
        }
        String firstFunction = model.getChainElements().get(0).getFuncName();
        if (firstFunction.toLowerCase().equals("max") || firstFunction.toLowerCase().equals("min") || firstFunction.toLowerCase().equals("fmax") || firstFunction.toLowerCase().equals("fmin")) {
            EsperEPL2GrammarParser.LibFunctionArgsContext firstArgs = model.getChainElements().get(0).getArgs();
            ASTLibFunctionHelper.handleMinMax(firstFunction, firstArgs, astExprNodeMap);
            return;
        }
        List<ExprChainedSpec> chain = new ArrayList<ExprChainedSpec>();
        ASTLibFunctionHelper.addChainRemainderFromOffset(model.getChainElements(), 0, chain, astExprNodeMap);
        boolean bl = distinct = model.getChainElements().get(0).getArgs() != null && model.getChainElements().get(0).getArgs().DISTINCT() != null;
        if (model.getOptionalClassIdent() != null) {
            chain.add(0, new ExprChainedSpec(model.getOptionalClassIdent(), Collections.<ExprNode>emptyList(), true));
            distinct = false;
        }
        if ((aggregationNode = ASTAggregationHelper.tryResolveAsAggregation(engineImportService, distinct, firstFunction = ((ExprChainedSpec)chain.get(0)).getName(), plugInAggregations, engineURI)) != null) {
            ExprNode exprNode;
            ExprChainedSpec firstSpec = (ExprChainedSpec)chain.remove(0);
            aggregationNode.addChildNodes(firstSpec.getParameters());
            if (chain.isEmpty()) {
                exprNode = aggregationNode;
            } else {
                exprNode = new ExprDotNode(chain, duckType, udfCache);
                exprNode.addChildNode(aggregationNode);
            }
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(exprNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        ExprDeclaredNodeImpl declaredNode = ExprDeclaredHelper.getExistsDeclaredExpr(firstFunction, ((ExprChainedSpec)chain.get(0)).getParameters(), expressionDeclarations.getExpressions(), exprDeclaredService, contextDescriptor);
        if (declaredNode != null) {
            ExprNodeBase exprNode;
            chain.remove(0);
            if (chain.isEmpty()) {
                exprNode = declaredNode;
            } else {
                exprNode = new ExprDotNode(chain, duckType, udfCache);
                exprNode.addChildNode(declaredNode);
            }
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(exprNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        ExprNodeScript scriptNode = ExprDeclaredHelper.getExistsScript(configurationInformation.getEngineDefaults().getScripts().getDefaultDialect(), ((ExprChainedSpec)chain.get(0)).getName(), ((ExprChainedSpec)chain.get(0)).getParameters(), scriptExpressions, exprDeclaredService);
        if (scriptNode != null) {
            ExprNodeBase exprNode;
            chain.remove(0);
            if (chain.isEmpty()) {
                exprNode = scriptNode;
            } else {
                exprNode = new ExprDotNode(chain, duckType, udfCache);
                exprNode.addChildNode(scriptNode);
            }
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(exprNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        Pair<ExprTableAccessNode, List<ExprChainedSpec>> tableInfo = ASTTableExprHelper.checkTableNameGetLibFunc(tableService, engineImportService, plugInAggregations, engineURI, firstFunction, chain);
        if (tableInfo != null) {
            ExprNode exprNode;
            ASTTableExprHelper.addTableExpressionReference(statementSpec, tableInfo.getFirst());
            chain = tableInfo.getSecond();
            if (chain.isEmpty()) {
                exprNode = tableInfo.getFirst();
            } else {
                exprNode = new ExprDotNode(chain, duckType, udfCache);
                exprNode.addChildNode(tableInfo.getFirst());
            }
            ASTExprHelper.exprCollectAddSubNodesAddParentNode(exprNode, (Tree)ctx, astExprNodeMap);
            return;
        }
        ExprDotNode dotNode = chain.size() == 1 ? new ExprDotNode(chain, false, false) : new ExprDotNode(chain, duckType, udfCache);
        ASTExprHelper.exprCollectAddSubNodesAddParentNode(dotNode, (Tree)ctx, astExprNodeMap);
    }

    private static void addChainRemainderFromOffset(List<ASTLibModelChainElement> chainElements, int offset, List<ExprChainedSpec> specList, Map<Tree, ExprNode> astExprNodeMap) {
        for (int i = offset; i < chainElements.size(); ++i) {
            ExprChainedSpec spec = ASTLibFunctionHelper.getLibFunctionChainSpec(chainElements.get(i), astExprNodeMap);
            specList.add(spec);
        }
    }

    private static ExprChainedSpec getLibFunctionChainSpec(ASTLibModelChainElement element, Map<Tree, ExprNode> astExprNodeMap) {
        String methodName = ASTConstantHelper.removeTicks(element.getFuncName());
        List<ExprNode> parameters = ASTLibFunctionHelper.getExprNodesLibFunc(element.getArgs(), astExprNodeMap);
        return new ExprChainedSpec(methodName, parameters, !element.isHasLeftParen());
    }

    private static ASTLibModel getModel(EsperEPL2GrammarParser.LibFunctionContext ctx, CommonTokenStream tokenStream) {
        ASTLibModelChainElement element;
        EsperEPL2GrammarParser.LibFunctionWithClassContext root = ctx.libFunctionWithClass();
        List<EsperEPL2GrammarParser.LibFunctionNoClassContext> ctxElements = ctx.libFunctionNoClass();
        if (ctxElements == null || ctxElements.isEmpty()) {
            String classIdent = root.classIdentifier() == null ? null : ASTUtil.unescapeClassIdent(root.classIdentifier());
            ASTLibModelChainElement ele = ASTLibFunctionHelper.fromRoot(root);
            return new ASTLibModel(classIdent, Collections.singletonList(ele));
        }
        ArrayList<ASTLibModelChainElement> chainElements = new ArrayList<ASTLibModelChainElement>(ctxElements.size() + 1);
        ASTLibModelChainElement rootElement = ASTLibFunctionHelper.fromRoot(root);
        chainElements.add(rootElement);
        for (EsperEPL2GrammarParser.LibFunctionNoClassContext chainedCtx : ctxElements) {
            ASTLibModelChainElement chainedElement = new ASTLibModelChainElement(chainedCtx.funcIdentChained().getText(), chainedCtx.libFunctionArgs(), chainedCtx.l != null);
            chainElements.add(chainedElement);
        }
        ArrayList<ASTLibModelChainElement> chainElementsNoArgs = new ArrayList<ASTLibModelChainElement>(chainElements.size());
        Iterator iterator = chainElements.iterator();
        while (iterator.hasNext() && !(element = (ASTLibModelChainElement)iterator.next()).isHasLeftParen()) {
            chainElementsNoArgs.add(element);
            iterator.remove();
        }
        StringWriter classIdentBuf = new StringWriter();
        String delimiter = "";
        if (root.classIdentifier() != null) {
            classIdentBuf.append(ASTUtil.unescapeClassIdent(root.classIdentifier()));
            delimiter = ".";
        }
        for (ASTLibModelChainElement noarg : chainElementsNoArgs) {
            classIdentBuf.append(delimiter);
            classIdentBuf.append(noarg.getFuncName());
            delimiter = ".";
        }
        if (chainElements.isEmpty()) {
            throw ASTWalkException.from("Encountered unrecognized lib function call", tokenStream, (RuleContext)ctx);
        }
        String classIdentifierString = classIdentBuf.toString();
        String classIdentifier = classIdentifierString.length() > 0 ? classIdentifierString : null;
        return new ASTLibModel(classIdentifier, chainElements);
    }

    public static ASTLibModelChainElement fromRoot(EsperEPL2GrammarParser.LibFunctionWithClassContext root) {
        if (root.funcIdentTop() != null) {
            return new ASTLibModelChainElement(root.funcIdentTop().getText(), root.libFunctionArgs(), root.l != null);
        }
        return new ASTLibModelChainElement(root.funcIdentInner().getText(), root.libFunctionArgs(), root.l != null);
    }

    private static void handleMinMax(String ident, EsperEPL2GrammarParser.LibFunctionArgsContext ctxArgs, Map<Tree, ExprNode> astExprNodeMap) {
        boolean isDistinct;
        MinMaxTypeEnum minMaxTypeEnum;
        String childNodeText = ident;
        boolean filtered = childNodeText.startsWith("f");
        if (childNodeText.toLowerCase().equals("min") || childNodeText.toLowerCase().equals("fmin")) {
            minMaxTypeEnum = MinMaxTypeEnum.MIN;
        } else if (childNodeText.toLowerCase().equals("max") || childNodeText.toLowerCase().equals("fmax")) {
            minMaxTypeEnum = MinMaxTypeEnum.MAX;
        } else {
            throw ASTWalkException.from("Uncountered unrecognized min or max node '" + ident + "'");
        }
        List<ExprNode> args = Collections.emptyList();
        if (ctxArgs != null && ctxArgs.libFunctionArgItem() != null) {
            args = ASTExprHelper.exprCollectSubNodes((Tree)ctxArgs, 0, astExprNodeMap);
        }
        int numArgsPositional = ExprAggregateNodeUtil.countPositionalArgs(args);
        boolean bl = isDistinct = ctxArgs != null && ctxArgs.DISTINCT() != null;
        if (numArgsPositional > 1 && isDistinct && !filtered) {
            throw ASTWalkException.from("The distinct keyword is not valid in per-row min and max functions with multiple sub-expressions");
        }
        ExprNodeBase minMaxNode = !isDistinct && numArgsPositional > 1 && !filtered ? new ExprMinMaxRowNode(minMaxTypeEnum) : new ExprMinMaxAggrNode(isDistinct, minMaxTypeEnum, filtered, false);
        minMaxNode.addChildNodes(args);
        astExprNodeMap.put((Tree)ctxArgs, minMaxNode);
    }

    public static class ASTLibModelChainElement {
        private final String funcName;
        private final EsperEPL2GrammarParser.LibFunctionArgsContext args;
        private final boolean hasLeftParen;

        public ASTLibModelChainElement(String funcName, EsperEPL2GrammarParser.LibFunctionArgsContext args, boolean hasLeftParen) {
            this.funcName = funcName;
            this.args = args;
            this.hasLeftParen = hasLeftParen;
        }

        public String getFuncName() {
            return this.funcName;
        }

        public EsperEPL2GrammarParser.LibFunctionArgsContext getArgs() {
            return this.args;
        }

        public boolean isHasLeftParen() {
            return this.hasLeftParen;
        }
    }

    public static class ASTLibModel {
        private final String optionalClassIdent;
        private final List<ASTLibModelChainElement> chainElements;

        public ASTLibModel(String optionalClassIdent, List<ASTLibModelChainElement> chainElements) {
            this.optionalClassIdent = optionalClassIdent;
            this.chainElements = chainElements;
        }

        public String getOptionalClassIdent() {
            return this.optionalClassIdent;
        }

        public List<ASTLibModelChainElement> getChainElements() {
            return this.chainElements;
        }
    }
}

