/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.Antlr4ErrorListener;
import com.espertech.esper.epl.parse.Antlr4ErrorStrategy;
import com.espertech.esper.epl.parse.EPLTreeWalkerListener;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.epl.parse.NoCaseSensitiveStream;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseHelper {
    public static final String newline = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(ParseHelper.class);

    public static void walk(Tree ast, EPLTreeWalkerListener listener, String expression, String eplStatementForErrorMsg) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".walk Walking AST using walker " + listener.getClass().getName()));
            }
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk((ParseTreeListener)listener, (ParseTree)ast);
            listener.end();
        }
        catch (RuntimeException e) {
            log.info((Object)("Error walking statement [" + expression + "]"), (Throwable)e);
            throw e;
        }
    }

    public static ParseResult parse(String expression, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector, boolean rewriteScript) throws EPException {
        Tree tree;
        NoCaseSensitiveStream input;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".parse Parsing expr=" + expression));
        }
        try {
            input = new NoCaseSensitiveStream(new StringReader(expression));
        }
        catch (IOException ex) {
            throw new EPException("IOException parsing expression '" + expression + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = ParseHelper.newLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        EsperEPL2GrammarParser parser = ParseHelper.newParser(tokens);
        try {
            tree = parseRuleSelector.invokeParseRule(parser);
        }
        catch (RecognitionException ex) {
            tokens.fill();
            if (rewriteScript && ParseHelper.isContainsScriptExpression(tokens)) {
                return ParseHelper.handleScriptRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
            }
            log.debug((Object)("Error parsing statement [" + expression + "]"), (Throwable)ex);
            throw ExceptionConvertor.convertStatement(ex, eplStatementErrorMsg, addPleaseCheck, parser);
        }
        catch (RuntimeException e) {
            try {
                tokens.fill();
            }
            catch (RuntimeException ex) {
                log.debug((Object)("Token-fill produced exception: " + e.getMessage()), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error parsing statement [" + eplStatementErrorMsg + "]"), (Throwable)e);
            }
            if (e.getCause() instanceof RecognitionException) {
                if (rewriteScript && ParseHelper.isContainsScriptExpression(tokens)) {
                    return ParseHelper.handleScriptRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
                }
                throw ExceptionConvertor.convertStatement((RecognitionException)e.getCause(), eplStatementErrorMsg, addPleaseCheck, parser);
            }
            throw e;
        }
        if (rewriteScript && ParseHelper.isContainsScriptExpression(tokens)) {
            return ParseHelper.handleScriptRewrite(tokens, eplStatementErrorMsg, addPleaseCheck, parseRuleSelector);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)".parse Dumping AST...");
            ASTUtil.dumpAST(tree);
        }
        String expressionWithoutAnnotation = expression;
        if (tree instanceof EsperEPL2GrammarParser.StartEPLExpressionRuleContext) {
            EsperEPL2GrammarParser.StartEPLExpressionRuleContext epl = (EsperEPL2GrammarParser.StartEPLExpressionRuleContext)tree;
            expressionWithoutAnnotation = ParseHelper.getNoAnnotation(expression, epl.annotationEnum(), tokens);
        } else if (tree instanceof EsperEPL2GrammarParser.StartPatternExpressionRuleContext) {
            EsperEPL2GrammarParser.StartPatternExpressionRuleContext pattern = (EsperEPL2GrammarParser.StartPatternExpressionRuleContext)tree;
            expressionWithoutAnnotation = ParseHelper.getNoAnnotation(expression, pattern.annotationEnum(), tokens);
        }
        return new ParseResult(tree, expressionWithoutAnnotation, tokens, Collections.<String>emptyList());
    }

    private static ParseResult handleScriptRewrite(CommonTokenStream tokens, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector) {
        ScriptResult rewriteExpression = ParseHelper.rewriteTokensScript(tokens);
        ParseResult result = ParseHelper.parse(rewriteExpression.getRewrittenEPL(), eplStatementErrorMsg, addPleaseCheck, parseRuleSelector, false);
        return new ParseResult(result.getTree(), result.getExpressionWithoutAnnotations(), result.getTokenStream(), rewriteExpression.getScripts());
    }

    private static String getNoAnnotation(String expression, List<EsperEPL2GrammarParser.AnnotationEnumContext> annos, CommonTokenStream tokens) {
        if (annos == null || annos.isEmpty()) {
            return expression;
        }
        Token lastAnnotationToken = annos.get(annos.size() - 1).getStop();
        if (lastAnnotationToken == null) {
            return null;
        }
        try {
            int line = lastAnnotationToken.getLine();
            int charpos = lastAnnotationToken.getCharPositionInLine();
            int fromChar = charpos + lastAnnotationToken.getText().length();
            if (line == 1) {
                return expression.substring(fromChar).trim();
            }
            String[] lines = expression.split("\r\n|\r|\n");
            StringBuilder buf = new StringBuilder();
            buf.append(lines[line - 1].substring(fromChar));
            for (int i = line; i < lines.length; ++i) {
                buf.append(lines[i]);
                if (i >= lines.length - 1) continue;
                buf.append(newline);
            }
            return buf.toString().trim();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error determining non-annotated expression sting: " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    private static ScriptResult rewriteTokensScript(CommonTokenStream tokens) {
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<UniformPair<Integer>> scriptTokenIndexRanges = new ArrayList<UniformPair<Integer>>();
        for (int i = 0; i < tokens.size(); ++i) {
            int endIndex;
            if (tokens.get(i).getType() != 122) continue;
            Token tokenBefore = ParseHelper.getTokenBefore(i, tokens);
            boolean isCreateExpressionClause = tokenBefore != null && tokenBefore.getType() == 1;
            Pair<String, Integer> nameAndNameStart = ParseHelper.findScriptName(i + 1, tokens);
            int startIndex = ParseHelper.findStartTokenScript(nameAndNameStart.getSecond(), tokens, 143);
            if (startIndex == -1 || (endIndex = ParseHelper.findEndTokenScript(startIndex + 1, tokens, 144, EsperEPL2GrammarParser.getAfterScriptTokens(), !isCreateExpressionClause)) == -1) continue;
            StringWriter writer = new StringWriter();
            for (int j = startIndex + 1; j < endIndex; ++j) {
                writer.append(tokens.get(j).getText());
            }
            scripts.add(writer.toString());
            scriptTokenIndexRanges.add(new UniformPair<Integer>(startIndex, endIndex));
        }
        String rewrittenEPL = ParseHelper.rewriteScripts(scriptTokenIndexRanges, tokens);
        return new ScriptResult(rewrittenEPL, scripts);
    }

    private static Token getTokenBefore(int i, CommonTokenStream tokens) {
        for (int position = i - 1; position >= 0; --position) {
            Token t = tokens.get(position);
            if (t.getChannel() == 99 || t.getType() == 185) continue;
            return t;
        }
        return null;
    }

    private static Pair<String, Integer> findScriptName(int start, CommonTokenStream tokens) {
        String lastIdent = null;
        int lastIdentIndex = 0;
        for (int i = start; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == 191) {
                lastIdent = tokens.get(i).getText();
                lastIdentIndex = i;
            }
            if (tokens.get(i).getType() == 141 || tokens.get(i).getType() == 143 && tokens.get(i + 1).getType() != 144) break;
        }
        if (lastIdent == null) {
            throw new IllegalStateException("Failed to parse expression name");
        }
        return new Pair<Object, Integer>(lastIdent, lastIdentIndex);
    }

    private static String rewriteScripts(List<UniformPair<Integer>> ranges, CommonTokenStream tokens) {
        Token t;
        if (ranges.isEmpty()) {
            return tokens.getText();
        }
        StringWriter writer = new StringWriter();
        int rangeIndex = 0;
        UniformPair<Integer> current = ranges.get(rangeIndex);
        for (int i = 0; i < tokens.size() && (t = tokens.get(i)).getType() != -1; ++i) {
            if (i < current.getFirst()) {
                writer.append(t.getText());
                continue;
            }
            if (i == current.getFirst()) {
                writer.append(t.getText());
                writer.append("'");
                continue;
            }
            if (i == current.getSecond()) {
                writer.append("'");
                writer.append(t.getText());
                if (ranges.size() > ++rangeIndex) {
                    current = ranges.get(rangeIndex);
                    continue;
                }
                current = new UniformPair<Integer>(-1, -1);
                continue;
            }
            if (t.getType() == 189 && i > current.getFirst() && i < current.getSecond()) {
                writer.append("\\'");
                writer.append(t.getText().substring(1, t.getText().length() - 1));
                writer.append("\\'");
                continue;
            }
            writer.append(t.getText());
        }
        return writer.toString();
    }

    private static int findEndTokenScript(int startIndex, CommonTokenStream tokens, int tokenTypeSearch, Set<Integer> afterScriptTokens, boolean requireAfterScriptToken) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == tokenTypeSearch) {
                if (!requireAfterScriptToken) {
                    return i;
                }
                for (int j = i + 1; j < tokens.size(); ++j) {
                    Token next = tokens.get(j);
                    if (next.getChannel() != 0) continue;
                    if (!afterScriptTokens.contains(next.getType())) break;
                    found = i;
                    break;
                }
            }
            if (found != -1) break;
        }
        return found;
    }

    private static boolean isContainsScriptExpression(CommonTokenStream tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            int startIndex;
            if (tokens.get(i).getType() != 122 || (startIndex = ParseHelper.findStartTokenScript(i + 1, tokens, 143)) == -1) continue;
            return true;
        }
        return false;
    }

    private static int findStartTokenScript(int startIndex, CommonTokenStream tokens, int tokenTypeSearch) {
        int found = -1;
        for (int i = startIndex; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != tokenTypeSearch) continue;
            return i;
        }
        return found;
    }

    public static EsperEPL2GrammarLexer newLexer(CharStream input) {
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        lex.removeErrorListeners();
        lex.addErrorListener(Antlr4ErrorListener.INSTANCE);
        return lex;
    }

    public static EsperEPL2GrammarParser newParser(CommonTokenStream tokens) {
        EsperEPL2GrammarParser g = new EsperEPL2GrammarParser((TokenStream)tokens);
        g.removeErrorListeners();
        g.addErrorListener(Antlr4ErrorListener.INSTANCE);
        g.setErrorHandler((ANTLRErrorStrategy)new Antlr4ErrorStrategy());
        return g;
    }

    public static boolean hasControlCharacters(String text) {
        String textWithoutControlCharacters = text.replaceAll("\\p{Cc}", "");
        return !textWithoutControlCharacters.equals(text);
    }

    private static class ScriptResult {
        private final String rewrittenEPL;
        private final List<String> scripts;

        private ScriptResult(String rewrittenEPL, List<String> scripts) {
            this.rewrittenEPL = rewrittenEPL;
            this.scripts = scripts;
        }

        public String getRewrittenEPL() {
            return this.rewrittenEPL;
        }

        public List<String> getScripts() {
            return this.scripts;
        }
    }
}

