/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.rettype;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.rettype.ClassEPType;
import com.espertech.esper.epl.rettype.ClassMultiValuedEPType;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EventEPType;
import com.espertech.esper.epl.rettype.EventMultiValuedEPType;
import com.espertech.esper.epl.rettype.NullEPType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.util.Collection;

public class EPTypeHelper {
    public static EventType getEventTypeSingleValued(EPType type) {
        if (type instanceof EventEPType) {
            return ((EventEPType)type).getType();
        }
        return null;
    }

    public static EventType getEventTypeMultiValued(EPType type) {
        if (type instanceof EventMultiValuedEPType) {
            return ((EventMultiValuedEPType)type).getComponent();
        }
        return null;
    }

    public static Class getClassMultiValued(EPType type) {
        if (type instanceof ClassMultiValuedEPType) {
            return ((ClassMultiValuedEPType)type).getComponent();
        }
        return null;
    }

    public static Class getClassSingleValued(EPType type) {
        if (type instanceof ClassEPType) {
            return ((ClassEPType)type).getType();
        }
        return null;
    }

    public static boolean isCarryEvent(EPType epType) {
        return epType instanceof EventMultiValuedEPType || epType instanceof EventEPType;
    }

    public static EventType getEventType(EPType epType) {
        if (epType instanceof EventMultiValuedEPType) {
            return ((EventMultiValuedEPType)epType).getComponent();
        }
        if (epType instanceof EventEPType) {
            return ((EventEPType)epType).getType();
        }
        return null;
    }

    public static EPType array(Class arrayComponentType) {
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("Invalid null array component type");
        }
        return new ClassMultiValuedEPType(JavaClassHelper.getArrayType(arrayComponentType), arrayComponentType);
    }

    public static EPType singleValue(Class singleValueType) {
        if (singleValueType != null && singleValueType.isArray()) {
            return new ClassMultiValuedEPType(singleValueType, singleValueType.getComponentType());
        }
        return new ClassEPType(singleValueType);
    }

    public static EPType nullValue() {
        return NullEPType.INSTANCE;
    }

    public static EPType collectionOfSingleValue(Class collectionComponentType) {
        if (collectionComponentType == null) {
            throw new IllegalArgumentException("Invalid null collection component type");
        }
        return new ClassMultiValuedEPType(Collection.class, collectionComponentType);
    }

    public static EPType collectionOfEvents(EventType eventTypeOfCollectionEvents) {
        if (eventTypeOfCollectionEvents == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new EventMultiValuedEPType(Collection.class, eventTypeOfCollectionEvents);
    }

    public static EPType singleEvent(EventType eventTypeOfSingleEvent) {
        if (eventTypeOfSingleEvent == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new EventEPType(eventTypeOfSingleEvent);
    }

    public static EPType fromMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (JavaClassHelper.isImplementsInterface(returnType, Collection.class)) {
            Class componentType = JavaClassHelper.getGenericReturnType(method, true);
            return EPTypeHelper.collectionOfSingleValue(componentType);
        }
        if (method.getReturnType().isArray()) {
            Class<?> componentType = method.getReturnType().getComponentType();
            return EPTypeHelper.array(componentType);
        }
        return EPTypeHelper.singleValue(method.getReturnType());
    }

    public static String toTypeDescriptive(EPType epType) {
        if (epType instanceof EventEPType) {
            EventEPType type = (EventEPType)epType;
            return "event type '" + type.getType().getName() + "'";
        }
        if (epType instanceof EventMultiValuedEPType) {
            EventMultiValuedEPType type = (EventMultiValuedEPType)epType;
            if (type.getContainer() == EventType[].class) {
                return "array of events of type '" + type.getComponent().getName() + "'";
            }
            return "collection of events of type '" + type.getComponent().getName() + "'";
        }
        if (epType instanceof ClassMultiValuedEPType) {
            ClassMultiValuedEPType type = (ClassMultiValuedEPType)epType;
            if (type.getContainer().isArray()) {
                return "array of " + type.getComponent().getSimpleName();
            }
            return "collection of " + type.getComponent().getSimpleName();
        }
        if (epType instanceof ClassEPType) {
            ClassEPType type = (ClassEPType)epType;
            return "class " + JavaClassHelper.getClassNameFullyQualPretty(type.getType());
        }
        if (epType instanceof NullEPType) {
            return "null type";
        }
        throw new IllegalArgumentException("Unrecognized type " + epType);
    }

    public static Class getNormalizedClass(EPType theType) {
        if (theType instanceof EventMultiValuedEPType) {
            EventMultiValuedEPType type = (EventMultiValuedEPType)theType;
            return JavaClassHelper.getArrayType(type.getComponent().getUnderlyingType());
        }
        if (theType instanceof EventEPType) {
            EventEPType type = (EventEPType)theType;
            return type.getType().getUnderlyingType();
        }
        if (theType instanceof ClassMultiValuedEPType) {
            ClassMultiValuedEPType type = (ClassMultiValuedEPType)theType;
            return type.getContainer();
        }
        if (theType instanceof ClassEPType) {
            ClassEPType type = (ClassEPType)theType;
            return type.getType();
        }
        if (theType instanceof NullEPType) {
            return null;
        }
        throw new IllegalArgumentException("Unrecognized type " + theType);
    }

    public static EPType optionalFromEnumerationExpr(String statementId, EventAdapterService eventAdapterService, ExprNode exprNode) throws ExprValidationException {
        if (!(exprNode instanceof ExprEvaluatorEnumeration)) {
            return null;
        }
        ExprEvaluatorEnumeration enumInfo = (ExprEvaluatorEnumeration)((Object)exprNode);
        if (enumInfo.getComponentTypeCollection() != null) {
            return EPTypeHelper.collectionOfSingleValue(enumInfo.getComponentTypeCollection());
        }
        EventType eventTypeSingle = enumInfo.getEventTypeSingle(eventAdapterService, statementId);
        if (eventTypeSingle != null) {
            return EPTypeHelper.singleEvent(eventTypeSingle);
        }
        EventType eventTypeColl = enumInfo.getEventTypeCollection(eventAdapterService, statementId);
        if (eventTypeColl != null) {
            return EPTypeHelper.collectionOfEvents(eventTypeColl);
        }
        return null;
    }

    public static EventType optionalIsEventTypeColl(EPType type) {
        if (type != null && type instanceof EventMultiValuedEPType) {
            return ((EventMultiValuedEPType)type).getComponent();
        }
        return null;
    }

    public static Class optionalIsComponentTypeColl(EPType type) {
        if (type != null && type instanceof ClassMultiValuedEPType) {
            return ((ClassMultiValuedEPType)type).getComponent();
        }
        return null;
    }

    public static EventType optionalIsEventTypeSingle(EPType type) {
        if (type != null && type instanceof EventEPType) {
            return ((EventEPType)type).getType();
        }
        return null;
    }
}

