/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.script.ExprNodeScriptEvalBase;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeScriptEvalJSR223
extends ExprNodeScriptEvalBase {
    private static final Log log = LogFactory.getLog(ExprNodeScriptEvalJSR223.class);
    private final CompiledScript executable;

    public ExprNodeScriptEvalJSR223(String scriptName, String statementName, String[] names, ExprEvaluator[] parameters, Class returnType, CompiledScript executable) {
        super(scriptName, statementName, names, parameters, returnType);
        this.executable = executable;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Bindings bindings = this.executable.getEngine().createBindings();
        bindings.put("epl", (Object)context.getAgentInstanceScriptContext());
        for (int i = 0; i < this.names.length; ++i) {
            bindings.put(this.names[i], this.parameters[i].evaluate(eventsPerStream, isNewData, context));
        }
        try {
            Object result = this.executable.eval(bindings);
            if (this.coercer != null) {
                return this.coercer.coerceBoxed((Number)result);
            }
            return result;
        }
        catch (ScriptException e) {
            String message = "Unexpected exception executing script '" + this.scriptName + "' for statement '" + this.statementName + "' : " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw new EPException(message, e);
        }
    }
}

