/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.script.mvel;

import com.espertech.esper.client.EPException;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class MVELInvoker {
    private static Class mvelClass;
    private static Class parserContextClass;
    private static Class execStatementClass;
    private static Method executeExpressionMethod;

    public static boolean isMVELInClasspath() {
        if (mvelClass == null) {
            MVELInvoker.init();
        }
        return MVELInvoker.assertClasses();
    }

    public static void analysisCompile(String expression, Object parserContext) throws InvocationTargetException {
        Method method;
        MVELInvoker.assertClasspath();
        try {
            method = mvelClass.getMethod("analysisCompile", String.class, parserContextClass);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
        try {
            method.invoke(null, expression, parserContext);
        }
        catch (IllegalAccessException e) {
            throw new EPException("Failed to access MVEL method: " + e.getMessage(), e);
        }
    }

    public static Object compileExpression(String expression, Object parserContext) throws InvocationTargetException {
        Method method;
        try {
            method = mvelClass.getMethod("compileExpression", String.class, parserContextClass);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
        try {
            return method.invoke(null, expression, parserContext);
        }
        catch (IllegalAccessException e) {
            throw new EPException("Failed to access MVEL method: " + e.getMessage(), e);
        }
    }

    public static Object newParserContext() {
        MVELInvoker.assertClasspath();
        try {
            return parserContextClass.newInstance();
        }
        catch (Exception e) {
            throw new EPException("Failed to instantiate MVEL ParserContext: " + e.getMessage(), e);
        }
    }

    public static Map<String, Class> getParserContextInputs(Object parserContext) {
        try {
            Method method = parserContextClass.getMethod("getInputs", new Class[0]);
            return (Map)method.invoke(parserContext, null);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
    }

    public static Object executeExpression(Object executable, Map<String, Object> parameters) throws InvocationTargetException {
        try {
            return executeExpressionMethod.invoke(null, executable, parameters);
        }
        catch (IllegalAccessException e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
    }

    public static void setParserContextStrongTyping(Object parserContext) {
        try {
            Method method = parserContextClass.getMethod("setStrongTyping", Boolean.TYPE);
            method.invoke(parserContext, true);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
    }

    public static void setParserContextInputs(Object parserContext, Map<String, Class> mvelInputParamTypes) {
        try {
            Method method = parserContextClass.getMethod("setInputs", Map.class);
            method.invoke(parserContext, mvelInputParamTypes);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
    }

    public static Class getExecutableStatementKnownReturnType(Object compiled) {
        try {
            Method method = execStatementClass.getMethod("getKnownEgressType", null);
            return (Class)method.invoke(compiled, null);
        }
        catch (Exception e) {
            throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
        }
    }

    private static void init() {
        mvelClass = JavaClassHelper.getClassInClasspath("org.mvel2.MVEL");
        parserContextClass = JavaClassHelper.getClassInClasspath("org.mvel2.ParserContext");
        execStatementClass = JavaClassHelper.getClassInClasspath("org.mvel2.compiler.ExecutableStatement");
        if (mvelClass != null) {
            try {
                executeExpressionMethod = mvelClass.getMethod("executeExpression", Object.class, Map.class);
            }
            catch (NoSuchMethodException e) {
                throw new EPException("Failed to find MVEL method: " + e.getMessage(), e);
            }
        }
    }

    private static void assertClasspath() {
        if (mvelClass == null) {
            MVELInvoker.init();
        }
        if (!MVELInvoker.assertClasses()) {
            throw new IllegalStateException("Failed to find MVEL in classpath");
        }
    }

    private static boolean assertClasses() {
        return mvelClass != null && parserContextClass != null;
    }
}

