/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorFactory;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw,
MetaDefItem,
Serializable {
    private static Log log = LogFactory.getLog(FilterStreamSpecRaw.class);
    private FilterSpecRaw rawFilterSpec;
    private static final long serialVersionUID = -7919060568262701953L;

    public FilterStreamSpecRaw(FilterSpecRaw rawFilterSpec, ViewSpec[] viewSpecs, String optionalStreamName, StreamSpecOptions streamSpecOptions) {
        super(optionalStreamName, viewSpecs, streamSpecOptions);
        this.rawFilterSpec = rawFilterSpec;
    }

    public FilterStreamSpecRaw() {
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    @Override
    public StreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, Collection<Integer> assignedTypeNumberStack, boolean isJoin, boolean isContextDeclaration, boolean isOnTrigger) throws ExprValidationException {
        String eventName = this.rawFilterSpec.getEventTypeName();
        if (context.getTableService() != null && context.getTableService().getTableMetadata(eventName) != null) {
            if (this.getViewSpecs() != null && this.getViewSpecs().length > 0) {
                throw new ExprValidationException("Views are not supported with tables");
            }
            if (this.getRawFilterSpec().getOptionalPropertyEvalSpec() != null) {
                throw new ExprValidationException("Contained-event expressions are not supported with tables");
            }
            TableMetadata tableMetadata = context.getTableService().getTableMetadata(eventName);
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{tableMetadata.getInternalEventType()}, new String[]{"s0"}, new boolean[]{true}, context.getEngineURI(), false);
            List<ExprNode> validatedNodes = FilterSpecCompiler.validateAllowSubquery(ExprNodeOrigin.FILTER, this.rawFilterSpec.getFilterExpressions(), streamTypeService, context, null, null);
            return new TableQueryStreamSpec(this.getOptionalStreamName(), this.getViewSpecs(), this.getOptions(), eventName, validatedNodes);
        }
        if (context.getNamedWindowService().isNamedWindow(eventName)) {
            EventType namedWindowType = context.getNamedWindowService().getProcessor(eventName).getTailView().getEventType();
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{namedWindowType}, new String[]{"s0"}, new boolean[]{true}, context.getEngineURI(), false);
            List<ExprNode> validatedNodes = FilterSpecCompiler.validateAllowSubquery(ExprNodeOrigin.FILTER, this.rawFilterSpec.getFilterExpressions(), streamTypeService, context, null, null);
            PropertyEvaluator optionalPropertyEvaluator = null;
            if (this.rawFilterSpec.getOptionalPropertyEvalSpec() != null) {
                optionalPropertyEvaluator = PropertyEvaluatorFactory.makeEvaluator(this.rawFilterSpec.getOptionalPropertyEvalSpec(), namedWindowType, this.getOptionalStreamName(), context.getEventAdapterService(), context.getMethodResolutionService(), context.getTimeProvider(), context.getVariableService(), context.getTableService(), context.getEngineURI(), context.getStatementId(), context.getStatementName(), context.getAnnotations(), assignedTypeNumberStack, context.getConfigSnapshot(), context.getNamedWindowService());
            }
            eventTypeReferences.add(((EventTypeSPI)namedWindowType).getMetadata().getPrimaryName());
            return new NamedWindowConsumerStreamSpec(eventName, this.getOptionalStreamName(), this.getViewSpecs(), validatedNodes, this.getOptions(), optionalPropertyEvaluator);
        }
        EventType eventType = null;
        if (context.getValueAddEventService().isRevisionTypeName(eventName)) {
            eventType = context.getValueAddEventService().getValueAddUnderlyingType(eventName);
            eventTypeReferences.add(((EventTypeSPI)eventType).getMetadata().getPrimaryName());
        }
        if (eventType == null && (eventType = FilterStreamSpecRaw.resolveType(context.getEngineURI(), eventName, context.getEventAdapterService(), context.getPlugInTypeResolutionURIs())) instanceof EventTypeSPI) {
            eventTypeReferences.add(((EventTypeSPI)eventType).getMetadata().getPrimaryName());
        }
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{super.getOptionalStreamName()}, new boolean[]{true}, context.getEngineURI(), false);
        FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(eventType, eventName, this.rawFilterSpec.getFilterExpressions(), this.rawFilterSpec.getOptionalPropertyEvalSpec(), null, null, streamTypeService, this.getOptionalStreamName(), context, assignedTypeNumberStack);
        return new FilterStreamSpecCompiled(spec, this.getViewSpecs(), this.getOptionalStreamName(), this.getOptions());
    }

    public static EventType resolveType(String engineURI, String eventName, EventAdapterService eventAdapterService, URI[] optionalResolutionURIs) throws ExprValidationException {
        int indexDot;
        EventType eventType = eventAdapterService.getExistsTypeByName(eventName);
        if (eventType != null) {
            return eventType;
        }
        String engineURIQualifier = engineURI;
        if (engineURI == null || "default".equals(engineURI)) {
            engineURIQualifier = "default";
        }
        if (eventName.startsWith(engineURIQualifier) && (indexDot = eventName.indexOf(".")) > 0) {
            String eventNameURI = eventName.substring(0, indexDot);
            String eventNameRemainder = eventName.substring(indexDot + 1);
            if (engineURIQualifier.equals(eventNameURI)) {
                eventType = eventAdapterService.getExistsTypeByName(eventNameRemainder);
            }
        }
        if (eventType != null) {
            return eventType;
        }
        String message = null;
        try {
            eventType = eventAdapterService.addBeanType(eventName, eventName, true, false, false, false);
        }
        catch (EventAdapterException ex) {
            log.debug((Object)(".resolveType Event type named '" + eventName + "' not resolved as Java-Class event"));
            message = "Failed to resolve event type: " + ex.getMessage();
        }
        try {
            eventType = eventAdapterService.addPlugInEventType(eventName, optionalResolutionURIs, null);
        }
        catch (EventAdapterException ex) {
            log.debug((Object)(".resolveType Event type named '" + eventName + "' not resolved by plug-in event representations"));
        }
        if (eventType == null) {
            throw new ExprValidationException(message);
        }
        return eventType;
    }
}

