/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MethodStreamSpec
extends StreamSpecBase
implements StreamSpecRaw,
StreamSpecCompiled,
MetaDefItem,
Serializable {
    private String ident;
    private String className;
    private String methodName;
    private List<ExprNode> expressions;
    private static final long serialVersionUID = -5290682188045211532L;

    public MethodStreamSpec(String optionalStreamName, ViewSpec[] viewSpecs, String ident, String className, String methodName, List<ExprNode> expressions) {
        super(optionalStreamName, viewSpecs, new StreamSpecOptions());
        this.ident = ident;
        this.className = className;
        this.methodName = methodName;
        this.expressions = expressions;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<ExprNode> getExpressions() {
        return this.expressions;
    }

    @Override
    public StreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, Collection<Integer> assignedTypeNumberStack, boolean isJoin, boolean isContextDeclaration, boolean isOnTrigger) throws ExprValidationException {
        if (!this.ident.equals("method")) {
            throw new ExprValidationException("Expecting keyword 'method', found '" + this.ident + "'");
        }
        if (this.methodName == null) {
            throw new ExprValidationException("No method name specified for method-based join");
        }
        return this;
    }
}

