/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.merge;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InternalEventRouteDest;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.merge.TableOnMergeAction;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.table.mgmt.TableStateRowFactory;
import com.espertech.esper.epl.table.onaction.TableOnMergeViewChangeHandler;
import com.espertech.esper.util.AuditPath;

public class TableOnMergeActionIns
extends TableOnMergeAction {
    private final SelectExprProcessor insertHelper;
    private final InternalEventRouter internalEventRouter;
    private final EPStatementHandle statementHandle;
    private final InternalEventRouteDest internalEventRouteDest;
    private final boolean audit;
    private final TableStateRowFactory tableStateRowFactory;

    public TableOnMergeActionIns(ExprEvaluator optionalFilter, SelectExprProcessor insertHelper, InternalEventRouter internalEventRouter, EPStatementHandle statementHandle, InternalEventRouteDest internalEventRouteDest, boolean audit, TableStateRowFactory tableStateRowFactory) {
        super(optionalFilter);
        this.insertHelper = insertHelper;
        this.internalEventRouter = internalEventRouter;
        this.statementHandle = statementHandle;
        this.internalEventRouteDest = internalEventRouteDest;
        this.audit = audit;
        this.tableStateRowFactory = tableStateRowFactory;
    }

    @Override
    public void apply(EventBean matchingEvent, EventBean[] eventsPerStream, TableStateInstance tableStateInstance, TableOnMergeViewChangeHandler changeHandlerAdded, TableOnMergeViewChangeHandler changeHandlerRemoved, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = this.insertHelper.process(eventsPerStream, true, true, exprEvaluatorContext);
        if (this.internalEventRouter == null) {
            AggregationRowPair aggs = this.tableStateRowFactory.makeAggs(exprEvaluatorContext.getAgentInstanceId(), null, null);
            ((Object[])theEvent.getUnderlying())[0] = aggs;
            tableStateInstance.addEvent(theEvent);
            if (changeHandlerAdded != null) {
                changeHandlerAdded.add(theEvent, eventsPerStream, true, exprEvaluatorContext);
            }
            return;
        }
        if (this.audit) {
            AuditPath.auditInsertInto(this.internalEventRouteDest.getEngineURI(), this.statementHandle.getStatementName(), theEvent);
        }
        this.internalEventRouter.route(theEvent, this.statementHandle, this.internalEventRouteDest, exprEvaluatorContext, false);
    }

    @Override
    public String getName() {
        return this.internalEventRouter != null ? "insert-into" : "select";
    }

    public boolean isInsertIntoBinding() {
        return this.internalEventRouter == null;
    }
}

