/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.table.strategy;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.table.ExprTableAccessEvalStrategy;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUngroupedBase;
import com.espertech.esper.epl.table.strategy.ExprTableEvalStrategyUtil;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public class ExprTableEvalStrategyUngroupedAccess
extends ExprTableEvalStrategyUngroupedBase
implements ExprTableAccessEvalStrategy {
    private final int slot;
    private final AggregationAccessor accessor;

    public ExprTableEvalStrategyUngroupedAccess(Lock lock, AtomicReference<ObjectArrayBackedEventBean> aggregationState, int slot, AggregationAccessor accessor) {
        super(lock, aggregationState);
        this.slot = slot;
        this.accessor = accessor;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ObjectArrayBackedEventBean event = this.lockTableReadAndGet(context);
        if (event == null) {
            return null;
        }
        AggregationState aggregationState = this.getAndLock(event, context);
        return this.accessor.getValue(aggregationState, eventsPerStream, isNewData, context);
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        throw new IllegalStateException("Not typable");
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ObjectArrayBackedEventBean event = this.lockTableReadAndGet(context);
        if (event == null) {
            return null;
        }
        AggregationState aggregationState = this.getAndLock(event, context);
        return this.accessor.getEnumerableEvents(aggregationState, eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ObjectArrayBackedEventBean event = this.lockTableReadAndGet(context);
        if (event == null) {
            return null;
        }
        AggregationState aggregationState = this.getAndLock(event, context);
        return this.accessor.getEnumerableEvent(aggregationState, eventsPerStream, isNewData, context);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ObjectArrayBackedEventBean event = this.lockTableReadAndGet(context);
        if (event == null) {
            return null;
        }
        AggregationState aggregationState = this.getAndLock(event, context);
        return this.accessor.getEnumerableScalar(aggregationState, eventsPerStream, isNewData, context);
    }

    private AggregationState getAndLock(ObjectArrayBackedEventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair row = ExprTableEvalStrategyUtil.getRow(event);
        return row.getStates()[this.slot];
    }
}

