/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.view.FilterExprViewIterator;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;

public class FilterExprView
extends ViewSupport {
    private final ExprNode exprNode;
    private final ExprEvaluator exprEvaluator;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public FilterExprView(ExprNode exprNode, ExprEvaluator exprEvaluator, ExprEvaluatorContext exprEvaluatorContext) {
        this.exprNode = exprNode;
        this.exprEvaluator = exprEvaluator;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new FilterExprViewIterator(this.parent.iterator(), this.exprEvaluator, this.exprEvaluatorContext);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        EventBean[] filteredNewData = this.filterEvents(this.exprEvaluator, newData, true, this.exprEvaluatorContext);
        EventBean[] filteredOldData = this.filterEvents(this.exprEvaluator, oldData, false, this.exprEvaluatorContext);
        if (filteredNewData != null || filteredOldData != null) {
            this.updateChildren(filteredNewData, filteredOldData);
        }
    }

    private EventBean[] filterEvents(ExprEvaluator exprEvaluator, EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] evalEventArr = new EventBean[1];
        boolean[] passResult = new boolean[events.length];
        int passCount = 0;
        for (int i = 0; i < events.length; ++i) {
            evalEventArr[0] = events[i];
            Boolean pass = (Boolean)exprEvaluator.evaluate(evalEventArr, isNewData, exprEvaluatorContext);
            if (pass == null || !pass.booleanValue()) continue;
            passResult[i] = true;
            ++passCount;
        }
        if (passCount == 0) {
            return null;
        }
        if (passCount == events.length) {
            return events;
        }
        EventBean[] resultArray = new EventBean[passCount];
        int count = 0;
        for (int i = 0; i < passResult.length; ++i) {
            if (!passResult[i]) continue;
            resultArray[count] = events[i];
            ++count;
        }
        return resultArray;
    }
}

