/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionCount;
import com.espertech.esper.epl.view.OutputConditionFactory;

public final class OutputConditionCountFactory
implements OutputConditionFactory {
    private final long eventRate;
    private final VariableMetaData variableMetaData;

    public OutputConditionCountFactory(int eventRate, VariableMetaData variableMetaData) {
        if (eventRate < 1 && variableMetaData == null) {
            throw new IllegalArgumentException("Limiting output by event count requires an event count of at least 1 or a variable name");
        }
        this.eventRate = eventRate;
        this.variableMetaData = variableMetaData;
    }

    @Override
    public OutputCondition make(AgentInstanceContext agentInstanceContext, OutputCallback outputCallback) {
        VariableReader variableReader = null;
        if (this.variableMetaData != null) {
            variableReader = agentInstanceContext.getStatementContext().getVariableService().getReader(this.variableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
        }
        return new OutputConditionCount(outputCallback, this.eventRate, variableReader);
    }

    public long getEventRate() {
        return this.eventRate;
    }

    public VariableMetaData getVariableMetaData() {
        return this.variableMetaData;
    }
}

