/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprConstantNodeImpl;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.epl.view.OutputConditionCountFactory;
import com.espertech.esper.epl.view.OutputConditionCrontabFactory;
import com.espertech.esper.epl.view.OutputConditionExpressionFactory;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputConditionNullFactory;
import com.espertech.esper.epl.view.OutputConditionTermFactory;
import com.espertech.esper.epl.view.OutputConditionTimeFactory;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionFactoryFactory {
    private static final Log log = LogFactory.getLog(OutputConditionFactoryFactory.class);

    public static OutputConditionFactory createCondition(OutputLimitSpec outputLimitSpec, StatementContext statementContext, boolean isGrouped, boolean isWithHavingClause, boolean isStartConditionOnCreation) throws ExprValidationException {
        if (outputLimitSpec == null) {
            return new OutputConditionNullFactory();
        }
        VariableMetaData variableMetaData = null;
        if (outputLimitSpec.getVariableName() != null) {
            variableMetaData = statementContext.getVariableService().getVariableMetaData(outputLimitSpec.getVariableName());
            if (variableMetaData == null) {
                throw new ExprValidationException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
            }
            String message = VariableServiceUtil.checkVariableContextName(statementContext.getContextDescriptor(), variableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST && isGrouped) {
            return new OutputConditionNullFactory();
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionCrontabFactory(outputLimitSpec.getCrontabAtSchedule(), statementContext, isStartConditionOnCreation);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionExpressionFactory(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), statementContext, outputLimitSpec.getAndAfterTerminateExpr(), outputLimitSpec.getAndAfterTerminateThenExpressions(), isStartConditionOnCreation);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(".createCondition creating OutputConditionCount with event rate " + outputLimitSpec));
            }
            if (variableMetaData != null && !JavaClassHelper.isNumericNonFP(variableMetaData.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionCountFactory(rate, variableMetaData);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TERM) {
            if (outputLimitSpec.getAndAfterTerminateExpr() == null && (outputLimitSpec.getAndAfterTerminateThenExpressions() == null || outputLimitSpec.getAndAfterTerminateThenExpressions().isEmpty())) {
                return new OutputConditionTermFactory();
            }
            return new OutputConditionExpressionFactory(new ExprConstantNodeImpl(false), Collections.<OnTriggerSetAssignment>emptyList(), statementContext, outputLimitSpec.getAndAfterTerminateExpr(), outputLimitSpec.getAndAfterTerminateThenExpressions(), isStartConditionOnCreation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createCondition creating OutputConditionTime with interval length " + outputLimitSpec.getRate()));
        }
        if (variableMetaData != null && !JavaClassHelper.isNumeric(variableMetaData.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionTimeFactory(outputLimitSpec.getTimePeriodExpr(), isStartConditionOnCreation);
    }
}

