/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.ScheduleSpecUtil;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionPolledCrontab
implements OutputConditionPolled {
    private Long currentReferencePoint;
    private AgentInstanceContext agentInstanceContext;
    private ScheduleSpec scheduleSpec;
    private long nextScheduledTime;
    private static final Log log = LogFactory.getLog(OutputConditionPolledCrontab.class);

    public OutputConditionPolledCrontab(List<ExprNode> scheduleSpecExpressionList, AgentInstanceContext agentInstanceContext) throws ExprValidationException {
        if (agentInstanceContext == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.agentInstanceContext = agentInstanceContext;
        ExprEvaluator[] expressions = new ExprEvaluator[scheduleSpecExpressionList.size()];
        int count = 0;
        ExprValidationContext validationContext = new ExprValidationContext(new StreamTypeServiceImpl(agentInstanceContext.getStatementContext().getEngineURI(), false), agentInstanceContext.getStatementContext().getMethodResolutionService(), null, agentInstanceContext.getStatementContext().getSchedulingService(), agentInstanceContext.getStatementContext().getVariableService(), agentInstanceContext.getStatementContext().getTableService(), agentInstanceContext, agentInstanceContext.getStatementContext().getEventAdapterService(), agentInstanceContext.getStatementContext().getStatementName(), agentInstanceContext.getStatementContext().getStatementId(), agentInstanceContext.getStatementContext().getAnnotations(), agentInstanceContext.getStatementContext().getContextDescriptor(), false, false, false, false, null, false);
        for (ExprNode parameters : scheduleSpecExpressionList) {
            ExprNode node = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.OUTPUTLIMIT, parameters, validationContext);
            expressions[count++] = node.getExprEvaluator();
        }
        try {
            Object[] scheduleSpecParameterList = OutputConditionPolledCrontab.evaluate(expressions, agentInstanceContext);
            this.scheduleSpec = ScheduleSpecUtil.computeValues(scheduleSpecParameterList);
        }
        catch (ScheduleParameterException e) {
            throw new IllegalArgumentException("Invalid schedule specification : " + e.getMessage(), e);
        }
    }

    @Override
    public final boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount));
        }
        boolean output = false;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = currentTime;
            this.nextScheduledTime = ScheduleComputeHelper.computeNextOccurance(this.scheduleSpec, currentTime, this.agentInstanceContext.getStatementContext().getMethodResolutionService().getEngineImportService().getTimeZone());
            output = true;
        }
        if (this.nextScheduledTime <= currentTime) {
            this.nextScheduledTime = ScheduleComputeHelper.computeNextOccurance(this.scheduleSpec, currentTime, this.agentInstanceContext.getStatementContext().getMethodResolutionService().getEngineImportService().getTimeZone());
            output = true;
        }
        return output;
    }

    private static Object[] evaluate(ExprEvaluator[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprEvaluator expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error((Object)message, (Throwable)ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }
}

