/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.view.OutputConditionExpressionTypeUtil;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import java.util.List;

public class OutputConditionPolledExpression
implements OutputConditionPolled {
    private final ExprEvaluator whenExpressionNode;
    private final AgentInstanceContext agentInstanceContext;
    private final VariableReadWritePackage variableReadWritePackage;
    private ObjectArrayEventBean builtinProperties;
    private EventBean[] eventsPerStream;
    private int totalNewEventsCount;
    private int totalOldEventsCount;
    private int totalNewEventsSum;
    private int totalOldEventsSum;
    private Long lastOutputTimestamp;

    public OutputConditionPolledExpression(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, AgentInstanceContext agentInstanceContext) throws ExprValidationException {
        this.whenExpressionNode = whenExpressionNode.getExprEvaluator();
        this.agentInstanceContext = agentInstanceContext;
        this.eventsPerStream = new EventBean[1];
        boolean containsBuiltinProperties = false;
        if (this.containsBuiltinProperties(whenExpressionNode)) {
            containsBuiltinProperties = true;
        } else if (assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (containsBuiltinProperties) {
            EventType oatype = agentInstanceContext.getStatementContext().getEventAdapterService().createAnonymousObjectArrayType(OutputConditionPolledExpression.class.getName(), OutputConditionExpressionTypeUtil.TYPEINFO);
            this.builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), oatype);
            this.lastOutputTimestamp = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
        this.variableReadWritePackage = assignments != null ? new VariableReadWritePackage(assignments, agentInstanceContext.getStatementContext().getVariableService(), agentInstanceContext.getStatementContext().getEventAdapterService()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.totalNewEventsCount += newEventsCount;
        this.totalOldEventsCount += oldEventsCount;
        this.totalNewEventsSum += newEventsCount;
        this.totalOldEventsSum += oldEventsCount;
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.resetBuiltinProperties();
            if (this.variableReadWritePackage != null) {
                if (this.builtinProperties != null) {
                    this.populateBuiltinProperties();
                    this.eventsPerStream[0] = this.builtinProperties;
                }
                this.variableReadWritePackage.writeVariables(this.agentInstanceContext.getStatementContext().getVariableService(), this.eventsPerStream, null, this.agentInstanceContext);
            }
        }
        return isOutput;
    }

    private void populateBuiltinProperties() {
        OutputConditionExpressionTypeUtil.populate(this.builtinProperties.getProperties(), this.totalNewEventsCount, this.totalOldEventsCount, this.totalNewEventsSum, this.totalOldEventsSum, this.lastOutputTimestamp);
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.populateBuiltinProperties();
            this.eventsPerStream[0] = this.builtinProperties;
        }
        boolean result = false;
        Boolean output = (Boolean)this.whenExpressionNode.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.totalNewEventsCount = 0;
            this.totalOldEventsCount = 0;
            this.lastOutputTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        }
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

