/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputConditionPolled;

public final class OutputConditionPolledTime
implements OutputConditionPolled {
    private ExprTimePeriod timePeriod;
    private AgentInstanceContext context;
    private Long lastUpdate;

    public OutputConditionPolledTime(ExprTimePeriod timePeriod, AgentInstanceContext context) {
        if (context == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.context = context;
        this.timePeriod = timePeriod;
        double numSeconds = timePeriod.evaluateAsSeconds(null, true, context);
        if (numSeconds < 0.001 && !timePeriod.hasVariable()) {
            throw new IllegalArgumentException("Output condition by time requires a interval size of at least 1 msec or a variable");
        }
    }

    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        long msecIntervalSize = this.timePeriod.nonconstEvaluator().deltaMillisecondsUseEngineTime(null, this.context);
        long current = this.context.getTimeProvider().getTime();
        if (this.lastUpdate == null || current - this.lastUpdate >= msecIntervalSize) {
            this.lastUpdate = current;
            return true;
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getName();
    }
}

