/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionBase;
import com.espertech.esper.epl.view.OutputConditionTimeFactory;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.StopCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionTime
extends OutputConditionBase
implements OutputCondition,
StopCallback {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final OutputConditionTimeFactory parent;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private EPStatementHandleCallback handle;
    private long currentScheduledTime;
    private static final Log log = LogFactory.getLog(OutputConditionTime.class);

    public OutputConditionTime(OutputCallback outputCallback, AgentInstanceContext context, OutputConditionTimeFactory outputConditionTimeFactory, boolean isStartConditionOnCreation) {
        super(outputCallback);
        this.context = context;
        this.parent = outputConditionTimeFactory;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartConditionOnCreation) {
            this.updateOutputCondition(0, 0);
        }
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount));
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (this.parent.getTimePeriod().hasVariable()) {
            long now = this.context.getStatementContext().getSchedulingService().getTime();
            ExprTimePeriodEvalDeltaResult delta = this.parent.getTimePeriod().nonconstEvaluator().deltaMillisecondsAddWReference(now, this.currentReferencePoint, null, true, this.context);
            if (delta.getDelta() != this.currentScheduledTime && this.isCallbackScheduled) {
                this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.scheduleCallback();
            }
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName();
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getStatementContext().getSchedulingService().getTime();
        ExprTimePeriodEvalDeltaResult delta = this.parent.getTimePeriod().nonconstEvaluator().deltaMillisecondsAddWReference(current, this.currentReferencePoint, null, true, this.context);
        long afterMSec = delta.getDelta();
        this.currentReferencePoint = delta.getLastReference();
        this.currentScheduledTime = afterMSec;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint));
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                OutputConditionTime.this.isCallbackScheduled = false;
                OutputConditionTime.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionTime.this.scheduleCallback();
            }
        };
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementAgentInstanceHandle(), callback);
        this.context.getStatementContext().getSchedulingService().add(afterMSec, this.handle, this.scheduleSlot);
        this.context.addTerminationCallback(this);
    }

    @Override
    public void stop() {
        if (this.handle != null) {
            this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

