/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewConditionDefault;
import com.espertech.esper.epl.view.OutputProcessViewConditionDefaultPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewConditionFirst;
import com.espertech.esper.epl.view.OutputProcessViewConditionFirstPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewConditionLastAllUnord;
import com.espertech.esper.epl.view.OutputProcessViewConditionLastAllUnordPostProcessAll;
import com.espertech.esper.epl.view.OutputProcessViewConditionSnapshot;
import com.espertech.esper.epl.view.OutputProcessViewConditionSnapshotPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewConditionFactory
extends OutputProcessViewDirectDistinctOrAfterFactory {
    private static final Log log = LogFactory.getLog(OutputProcessViewConditionFactory.class);
    private final OutputConditionFactory outputConditionFactory;
    private final int streamCount;
    private final ConditionType conditionType;
    private final OutputLimitLimitType outputLimitLimitType;
    private final boolean terminable;
    private final boolean hasAfter;
    private final boolean isUnaggregatedUngrouped;
    private final SelectClauseStreamSelectorEnum selectClauseStreamSelectorEnum;

    public OutputProcessViewConditionFactory(StatementContext statementContext, OutputStrategyPostProcessFactory postProcessFactory, boolean distinct, ExprTimePeriod afterTimePeriod, Integer afterConditionNumberOfEvents, EventType resultEventType, OutputConditionFactory outputConditionFactory, int streamCount, ConditionType conditionType, OutputLimitLimitType outputLimitLimitType, boolean terminable, boolean hasAfter, boolean isUnaggregatedUngrouped, SelectClauseStreamSelectorEnum selectClauseStreamSelectorEnum) {
        super(statementContext, postProcessFactory, distinct, afterTimePeriod, afterConditionNumberOfEvents, resultEventType);
        this.outputConditionFactory = outputConditionFactory;
        this.streamCount = streamCount;
        this.conditionType = conditionType;
        this.outputLimitLimitType = outputLimitLimitType;
        this.terminable = terminable;
        this.hasAfter = hasAfter;
        this.isUnaggregatedUngrouped = isUnaggregatedUngrouped;
        this.selectClauseStreamSelectorEnum = selectClauseStreamSelectorEnum;
    }

    @Override
    public OutputProcessViewBase makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        boolean isAfterConditionSatisfied = true;
        Long afterConditionTime = null;
        if (this.afterConditionNumberOfEvents != null) {
            isAfterConditionSatisfied = false;
        } else if (this.afterTimePeriod != null) {
            isAfterConditionSatisfied = false;
            long delta = this.afterTimePeriod.nonconstEvaluator().deltaMillisecondsUseEngineTime(null, agentInstanceContext);
            afterConditionTime = agentInstanceContext.getStatementContext().getTimeProvider().getTime() + delta;
        }
        if (this.conditionType == ConditionType.SNAPSHOT) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionSnapshot(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionSnapshotPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.conditionType == ConditionType.POLICY_FIRST) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionFirst(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionFirstPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.conditionType == ConditionType.POLICY_LASTALL_UNORDERED) {
            if (this.postProcessFactory == null) {
                return new OutputProcessViewConditionLastAllUnord(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
            }
            OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
            return new OutputProcessViewConditionLastAllUnordPostProcessAll(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
        }
        if (this.postProcessFactory == null) {
            return new OutputProcessViewConditionDefault(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext);
        }
        OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewConditionDefaultPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, agentInstanceContext, postProcess);
    }

    public OutputConditionFactory getOutputConditionFactory() {
        return this.outputConditionFactory;
    }

    public int getStreamCount() {
        return this.streamCount;
    }

    public OutputLimitLimitType getOutputLimitLimitType() {
        return this.outputLimitLimitType;
    }

    public boolean isTerminable() {
        return this.terminable;
    }

    public boolean isHasAfter() {
        return this.hasAfter;
    }

    public boolean isUnaggregatedUngrouped() {
        return this.isUnaggregatedUngrouped;
    }

    public SelectClauseStreamSelectorEnum getSelectClauseStreamSelectorEnum() {
        return this.selectClauseStreamSelectorEnum;
    }

    public static enum ConditionType {
        SNAPSHOT,
        POLICY_FIRST,
        POLICY_LASTALL_UNORDERED,
        POLICY_NONFIRST;

    }
}

