/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfter;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfterPostProcess;
import com.espertech.esper.epl.view.OutputProcessViewDirectFactory;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;
import com.espertech.esper.epl.view.OutputStrategyPostProcessFactory;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventTypeSPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewDirectDistinctOrAfterFactory
extends OutputProcessViewDirectFactory {
    private static final Log log = LogFactory.getLog(OutputProcessViewDirectDistinctOrAfterFactory.class);
    private final boolean isDistinct;
    protected final ExprTimePeriod afterTimePeriod;
    protected final Integer afterConditionNumberOfEvents;
    private EventBeanReader eventBeanReader;

    public OutputProcessViewDirectDistinctOrAfterFactory(StatementContext statementContext, OutputStrategyPostProcessFactory postProcessFactory, boolean distinct, ExprTimePeriod afterTimePeriod, Integer afterConditionNumberOfEvents, EventType resultEventType) {
        super(statementContext, postProcessFactory);
        this.isDistinct = distinct;
        this.afterTimePeriod = afterTimePeriod;
        this.afterConditionNumberOfEvents = afterConditionNumberOfEvents;
        if (this.isDistinct) {
            if (resultEventType instanceof EventTypeSPI) {
                EventTypeSPI eventTypeSPI = (EventTypeSPI)resultEventType;
                this.eventBeanReader = eventTypeSPI.getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(resultEventType);
            }
        }
    }

    @Override
    public OutputProcessViewBase makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        boolean isAfterConditionSatisfied = true;
        Long afterConditionTime = null;
        if (this.afterConditionNumberOfEvents != null) {
            isAfterConditionSatisfied = false;
        } else if (this.afterTimePeriod != null) {
            isAfterConditionSatisfied = false;
            long delta = this.afterTimePeriod.nonconstEvaluator().deltaMillisecondsUseEngineTime(null, agentInstanceContext);
            afterConditionTime = agentInstanceContext.getStatementContext().getTimeProvider().getTime() + delta;
        }
        if (this.postProcessFactory == null) {
            return new OutputProcessViewDirectDistinctOrAfter(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this);
        }
        OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewDirectDistinctOrAfterPostProcess(resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, postProcess);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public EventBeanReader getEventBeanReader() {
        return this.eventBeanReader;
    }
}

