/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.InternalEventRouter;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;

public class OutputStrategyPostProcessFactory {
    private final boolean isRoute;
    private final SelectClauseStreamSelectorEnum insertIntoStreamSelector;
    private final SelectClauseStreamSelectorEnum selectStreamDirEnum;
    private final InternalEventRouter internalEventRouter;
    private final EPStatementHandle epStatementHandle;
    private final boolean addToFront;
    private final TableService tableService;
    private final String tableName;

    public OutputStrategyPostProcessFactory(boolean route, SelectClauseStreamSelectorEnum insertIntoStreamSelector, SelectClauseStreamSelectorEnum selectStreamDirEnum, InternalEventRouter internalEventRouter, EPStatementHandle epStatementHandle, boolean addToFront, TableService tableService, String tableName) {
        this.isRoute = route;
        this.insertIntoStreamSelector = insertIntoStreamSelector;
        this.selectStreamDirEnum = selectStreamDirEnum;
        this.internalEventRouter = internalEventRouter;
        this.epStatementHandle = epStatementHandle;
        this.addToFront = addToFront;
        this.tableService = tableService;
        this.tableName = tableName;
    }

    public OutputStrategyPostProcess make(AgentInstanceContext agentInstanceContext) {
        TableStateInstance tableStateInstance = null;
        if (this.tableName != null) {
            tableStateInstance = this.tableService.getState(this.tableName, agentInstanceContext.getAgentInstanceId());
        }
        return new OutputStrategyPostProcess(this, agentInstanceContext, tableStateInstance);
    }

    public boolean isRoute() {
        return this.isRoute;
    }

    public SelectClauseStreamSelectorEnum getInsertIntoStreamSelector() {
        return this.insertIntoStreamSelector;
    }

    public SelectClauseStreamSelectorEnum getSelectStreamDirEnum() {
        return this.selectStreamDirEnum;
    }

    public InternalEventRouter getInternalEventRouter() {
        return this.internalEventRouter;
    }

    public EPStatementHandle getEpStatementHandle() {
        return this.epStatementHandle;
    }

    public boolean isAddToFront() {
        return this.addToFront;
    }
}

