/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.virtualdw;

import com.espertech.esper.client.EventBeanFactory;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.VirtualDataWindow;
import com.espertech.esper.client.hook.VirtualDataWindowContext;
import com.espertech.esper.client.hook.VirtualDataWindowFactory;
import com.espertech.esper.client.hook.VirtualDataWindowFactoryContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWViewImpl;
import com.espertech.esper.epl.virtualdw.VirtualDataWindowOutStreamImpl;
import com.espertech.esper.event.EventAdapterServiceHelper;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualDWViewFactoryImpl
implements ViewFactory,
DataWindowViewFactory,
VirtualDWViewFactory {
    private static Log log = LogFactory.getLog(VirtualDWViewFactoryImpl.class);
    private Serializable customConfiguration;
    private ViewFactoryContext viewFactoryContext;
    private List<ExprNode> viewParameters;
    private String namedWindowName;
    private VirtualDataWindowFactory virtualDataWindowFactory;
    private EventType parentEventType;
    private Object[] viewParameterArr;
    private ExprNode[] viewParameterExp;
    private EventBeanFactory eventBeanFactory;

    public VirtualDWViewFactoryImpl(Class first, String namedWindowName, Serializable customConfiguration) throws ViewProcessingException {
        if (!JavaClassHelper.isImplementsInterface(first, VirtualDataWindowFactory.class)) {
            throw new ViewProcessingException("Virtual data window factory class " + first.getName() + " does not implement the interface " + VirtualDataWindowFactory.class.getName());
        }
        this.customConfiguration = customConfiguration;
        this.namedWindowName = namedWindowName;
        this.virtualDataWindowFactory = (VirtualDataWindowFactory)JavaClassHelper.instantiate(VirtualDataWindowFactory.class, first.getName());
    }

    @Override
    public Set<String> getUniqueKeys() {
        return this.virtualDataWindowFactory.getUniqueKeyPropertyNames();
    }

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParameters) throws ViewParameterException {
        this.viewFactoryContext = viewFactoryContext;
        this.viewParameters = viewParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.parentEventType = parentEventType;
        ExprNode[] validatedNodes = ViewFactorySupport.validate(this.viewFactoryContext.getViewName(), parentEventType, this.viewFactoryContext.getStatementContext(), this.viewParameters, true);
        this.viewParameterArr = new Object[validatedNodes.length];
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(this.viewFactoryContext.getStatementContext(), false);
        for (int i = 0; i < validatedNodes.length; ++i) {
            try {
                this.viewParameterArr[i] = ViewFactorySupport.evaluateAssertNoProperties(this.viewFactoryContext.getViewName(), validatedNodes[i], i, evaluatorContextStmt);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.viewParameterExp = ViewFactorySupport.validate(this.viewFactoryContext.getViewName(), parentEventType, this.viewFactoryContext.getStatementContext(), this.viewParameters, true);
        try {
            this.eventBeanFactory = EventAdapterServiceHelper.getFactoryForType(parentEventType, statementContext.getEventAdapterService());
            this.virtualDataWindowFactory.initialize(new VirtualDataWindowFactoryContext(parentEventType, this.viewParameterArr, this.viewParameterExp, this.eventBeanFactory, this.namedWindowName, this.viewFactoryContext, this.customConfiguration));
        }
        catch (RuntimeException ex) {
            throw new ViewParameterException("Validation exception initializing virtual data window '" + this.namedWindowName + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        VirtualDataWindow window;
        VirtualDataWindowOutStreamImpl outputStream = new VirtualDataWindowOutStreamImpl();
        VirtualDataWindowContext context = new VirtualDataWindowContext(agentInstanceViewFactoryContext.getAgentInstanceContext(), this.parentEventType, this.viewParameterArr, this.viewParameterExp, this.eventBeanFactory, outputStream, this.namedWindowName, this.viewFactoryContext, this.customConfiguration);
        try {
            window = this.virtualDataWindowFactory.create(context);
        }
        catch (Exception ex) {
            throw new ViewProcessingException("Exception returned by virtual data window factory upon creation: " + ex.getMessage(), ex);
        }
        VirtualDWViewImpl view = new VirtualDWViewImpl(window, this.parentEventType, this.namedWindowName);
        outputStream.setView(view);
        return view;
    }

    @Override
    public EventType getEventType() {
        return this.parentEventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    @Override
    public void destroyNamedWindow() {
        if (this.virtualDataWindowFactory != null) {
            this.virtualDataWindowFactory.destroyAllContextPartitions();
        }
    }

    @Override
    public String getViewName() {
        return "Virtual Data Window";
    }
}

