/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.virtualdw;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.VirtualDataWindow;
import com.espertech.esper.client.hook.VirtualDataWindowEventStartIndex;
import com.espertech.esper.client.hook.VirtualDataWindowEventStopIndex;
import com.espertech.esper.client.hook.VirtualDataWindowEventStopWindow;
import com.espertech.esper.client.hook.VirtualDataWindowKeyRange;
import com.espertech.esper.client.hook.VirtualDataWindowLookup;
import com.espertech.esper.client.hook.VirtualDataWindowLookupContext;
import com.espertech.esper.client.hook.VirtualDataWindowLookupFieldDesc;
import com.espertech.esper.client.hook.VirtualDataWindowLookupOp;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropPlan;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateIndexItem;
import com.espertech.esper.epl.spec.CreateIndexType;
import com.espertech.esper.epl.virtualdw.JoinExecTableLookupStrategyVirtualDW;
import com.espertech.esper.epl.virtualdw.SubordTableLookupStrategyVirtualDW;
import com.espertech.esper.epl.virtualdw.VirtualDWEventTable;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.epl.virtualdw.VirtualDataWindowLookupContextSPI;
import com.espertech.esper.filter.Range;
import com.espertech.esper.view.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualDWViewImpl
extends ViewSupport
implements VirtualDWView {
    private static EventTableOrganization TABLE_ORGANIZATION = new EventTableOrganization(null, false, false, 0, null, EventTableOrganization.EventTableOrganizationType.VDW);
    private static final Log log = LogFactory.getLog(VirtualDWViewImpl.class);
    private final VirtualDataWindow dataExternal;
    private final EventType eventType;
    private final String namedWindowName;
    private String lastAccessedByStatementName;
    private int lastAccessedByNum;

    public VirtualDWViewImpl(VirtualDataWindow dataExternal, EventType eventType, String namedWindowName) {
        this.dataExternal = dataExternal;
        this.eventType = eventType;
        this.namedWindowName = namedWindowName;
    }

    @Override
    public VirtualDataWindow getVirtualDataWindow() {
        return this.dataExternal;
    }

    @Override
    public Pair<IndexMultiKey, EventTable> getSubordinateQueryDesc(boolean unique, List<IndexedPropDesc> hashedProps, List<IndexedPropDesc> btreeProps) {
        ArrayList<VirtualDataWindowLookupFieldDesc> hashFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        for (IndexedPropDesc hashprop : hashedProps) {
            hashFields.add(new VirtualDataWindowLookupFieldDesc(hashprop.getIndexPropName(), VirtualDataWindowLookupOp.EQUALS, hashprop.getCoercionType()));
        }
        ArrayList<VirtualDataWindowLookupFieldDesc> btreeFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        for (IndexedPropDesc btreeprop : btreeProps) {
            btreeFields.add(new VirtualDataWindowLookupFieldDesc(btreeprop.getIndexPropName(), null, btreeprop.getCoercionType()));
        }
        VirtualDWEventTable eventTable = new VirtualDWEventTable(unique, hashFields, btreeFields, TABLE_ORGANIZATION);
        IndexMultiKey imk = new IndexMultiKey(unique, hashedProps, btreeProps);
        return new Pair<IndexMultiKey, EventTable>(imk, eventTable);
    }

    @Override
    public SubordTableLookupStrategy getSubordinateLookupStrategy(String accessedByStatementName, String accessedByStatementId, Annotation[] accessedByStmtAnnotations, EventType[] outerStreamTypes, List<SubordPropHashKey> hashKeys, CoercionDesc hashKeyCoercionTypes, List<SubordPropRangeKey> rangeKeys, CoercionDesc rangeKeyCoercionTypes, boolean nwOnTrigger, EventTable eventTable, SubordPropPlan joinDesc, boolean forceTableScan) {
        VirtualDWEventTable noopTable = (VirtualDWEventTable)eventTable;
        for (int i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(rangeKeys.get(i).getRangeInfo().getType().getStringOp());
            noopTable.getBtreeAccess().get(i).setOperator(op);
        }
        if (this.lastAccessedByStatementName == null || !this.lastAccessedByStatementName.equals(accessedByStatementName)) {
            this.lastAccessedByNum = 0;
        }
        ++this.lastAccessedByNum;
        VirtualDataWindowLookupContextSPI context = new VirtualDataWindowLookupContextSPI(accessedByStatementName, accessedByStatementId, accessedByStmtAnnotations, false, this.namedWindowName, noopTable.getHashAccess(), noopTable.getBtreeAccess(), joinDesc, forceTableScan, outerStreamTypes, accessedByStatementName, this.lastAccessedByNum);
        VirtualDataWindowLookup index = this.dataExternal.getLookup(context);
        this.checkIndex(index);
        return new SubordTableLookupStrategyVirtualDW(this.namedWindowName, index, hashKeys, hashKeyCoercionTypes, rangeKeys, rangeKeyCoercionTypes, nwOnTrigger, outerStreamTypes.length);
    }

    @Override
    public EventTable getJoinIndexTable(QueryPlanIndexItem queryPlanIndexItem) {
        ArrayList<VirtualDataWindowLookupFieldDesc> hashFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        int count = 0;
        if (queryPlanIndexItem.getIndexProps() != null) {
            for (String indexProp : queryPlanIndexItem.getIndexProps()) {
                Class coercionType = queryPlanIndexItem.getOptIndexCoercionTypes() == null ? null : queryPlanIndexItem.getOptIndexCoercionTypes()[count];
                hashFields.add(new VirtualDataWindowLookupFieldDesc(indexProp, VirtualDataWindowLookupOp.EQUALS, coercionType));
                ++count;
            }
        }
        ArrayList<VirtualDataWindowLookupFieldDesc> btreeFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        count = 0;
        if (queryPlanIndexItem.getRangeProps() != null) {
            for (String btreeprop : queryPlanIndexItem.getRangeProps()) {
                Class coercionType = queryPlanIndexItem.getOptRangeCoercionTypes() == null ? null : queryPlanIndexItem.getOptRangeCoercionTypes()[count];
                btreeFields.add(new VirtualDataWindowLookupFieldDesc(btreeprop, null, coercionType));
                ++count;
            }
        }
        return new VirtualDWEventTable(false, hashFields, btreeFields, TABLE_ORGANIZATION);
    }

    @Override
    public JoinExecTableLookupStrategy getJoinLookupStrategy(String accessedByStmtName, String accessedByStmtId, Annotation[] accessedByStmtAnnotations, EventTable[] eventTables, TableLookupKeyDesc keyDescriptor, int lookupStreamNum) {
        int i;
        VirtualDWEventTable noopTable = (VirtualDWEventTable)eventTables[0];
        for (i = 0; i < noopTable.getHashAccess().size(); ++i) {
            QueryGraphValueEntryHashKeyed hashKey = keyDescriptor.getHashes().get(i);
            noopTable.getHashAccess().get(i).setLookupValueType(hashKey.getKeyExpr().getExprEvaluator().getType());
        }
        for (i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            QueryGraphValueEntryRange range = keyDescriptor.getRanges().get(i);
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(range.getType().getStringOp());
            VirtualDataWindowLookupFieldDesc rangeField = noopTable.getBtreeAccess().get(i);
            rangeField.setOperator(op);
            if (range instanceof QueryGraphValueEntryRangeRelOp) {
                rangeField.setLookupValueType(((QueryGraphValueEntryRangeRelOp)range).getExpression().getExprEvaluator().getType());
                continue;
            }
            rangeField.setLookupValueType(((QueryGraphValueEntryRangeIn)range).getExprStart().getExprEvaluator().getType());
        }
        VirtualDataWindowLookup index = this.dataExternal.getLookup(new VirtualDataWindowLookupContext(accessedByStmtName, accessedByStmtId, accessedByStmtAnnotations, false, this.namedWindowName, noopTable.getHashAccess(), noopTable.getBtreeAccess()));
        this.checkIndex(index);
        return new JoinExecTableLookupStrategyVirtualDW(this.namedWindowName, index, keyDescriptor, lookupStreamNum);
    }

    @Override
    public Pair<IndexMultiKey, EventTable> getFireAndForgetDesc(Set<String> keysAvailable, Set<String> rangesAvailable) {
        ArrayList<VirtualDataWindowLookupFieldDesc> hashFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        ArrayList<IndexedPropDesc> hashIndexedFields = new ArrayList<IndexedPropDesc>();
        for (String hashprop : keysAvailable) {
            hashFields.add(new VirtualDataWindowLookupFieldDesc(hashprop, VirtualDataWindowLookupOp.EQUALS, null));
            hashIndexedFields.add(new IndexedPropDesc(hashprop, null));
        }
        ArrayList<VirtualDataWindowLookupFieldDesc> btreeFields = new ArrayList<VirtualDataWindowLookupFieldDesc>();
        ArrayList<IndexedPropDesc> btreeIndexedFields = new ArrayList<IndexedPropDesc>();
        for (String btreeprop : rangesAvailable) {
            btreeFields.add(new VirtualDataWindowLookupFieldDesc(btreeprop, null, null));
            btreeIndexedFields.add(new IndexedPropDesc(btreeprop, null));
        }
        VirtualDWEventTable noopTable = new VirtualDWEventTable(false, hashFields, btreeFields, TABLE_ORGANIZATION);
        IndexMultiKey imk = new IndexMultiKey(false, hashIndexedFields, btreeIndexedFields);
        return new Pair<IndexMultiKey, EventTable>(imk, noopTable);
    }

    @Override
    public Collection<EventBean> getFireAndForgetData(EventTable eventTable, Object[] keyValues, RangeIndexLookupValue[] rangeValues, Annotation[] annotations) {
        VirtualDWEventTable noopTable = (VirtualDWEventTable)eventTable;
        for (int i = 0; i < noopTable.getBtreeAccess().size(); ++i) {
            RangeIndexLookupValueRange range = (RangeIndexLookupValueRange)rangeValues[i];
            VirtualDataWindowLookupOp op = VirtualDataWindowLookupOp.fromOpString(range.getOperator().getStringOp());
            noopTable.getBtreeAccess().get(i).setOperator(op);
        }
        Object[] keys = new Object[keyValues.length + rangeValues.length];
        for (int i = 0; i < keyValues.length; ++i) {
            keys[i] = keyValues[i];
            noopTable.getHashAccess().get(i).setLookupValueType(keyValues[i] == null ? null : keyValues[i].getClass());
        }
        int offset = keyValues.length;
        for (int j = 0; j < rangeValues.length; ++j) {
            Object rangeValue = rangeValues[j].getValue();
            if (rangeValue instanceof Range) {
                Range range = (Range)rangeValue;
                keys[j + offset] = new VirtualDataWindowKeyRange(range.getLowEndpoint(), range.getHighEndpoint());
                noopTable.getBtreeAccess().get(j).setLookupValueType(range.getLowEndpoint() == null ? null : range.getLowEndpoint().getClass());
                continue;
            }
            keys[j + offset] = rangeValue;
            noopTable.getBtreeAccess().get(j).setLookupValueType(rangeValue == null ? null : rangeValue.getClass());
        }
        VirtualDataWindowLookup index = this.dataExternal.getLookup(new VirtualDataWindowLookupContext(null, null, annotations, true, this.namedWindowName, noopTable.getHashAccess(), noopTable.getBtreeAccess()));
        this.checkIndex(index);
        if (index == null) {
            throw new EPException("Exception obtaining index from virtual data window '" + this.namedWindowName + "'");
        }
        Set<EventBean> events = null;
        try {
            events = index.lookup(keys, null);
        }
        catch (RuntimeException ex) {
            log.warn((Object)("Exception encountered invoking virtual data window external index for window '" + this.namedWindowName + "': " + ex.getMessage()), (Throwable)ex);
        }
        return events;
    }

    private void checkIndex(VirtualDataWindowLookup index) {
        if (index == null) {
            throw new EPException("Exception obtaining index lookup from virtual data window, the implementation has returned a null index");
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.dataExternal.update(newData, oldData);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public void destroy() {
        this.dataExternal.destroy();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.dataExternal.iterator();
    }

    @Override
    public void handleStartIndex(CreateIndexDesc spec) {
        try {
            ArrayList<VirtualDataWindowEventStartIndex.VDWCreateIndexField> fields = new ArrayList<VirtualDataWindowEventStartIndex.VDWCreateIndexField>();
            for (CreateIndexItem col : spec.getColumns()) {
                fields.add(new VirtualDataWindowEventStartIndex.VDWCreateIndexField(col.getName(), col.getType() == CreateIndexType.HASH));
            }
            VirtualDataWindowEventStartIndex create = new VirtualDataWindowEventStartIndex(spec.getWindowName(), spec.getIndexName(), fields, spec.isUnique());
            this.dataExternal.handleEvent(create);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle start-index event for window '" + this.namedWindowName + "': " + ex.getMessage();
            log.warn((Object)message, (Throwable)ex);
            throw new EPException(message, ex);
        }
    }

    @Override
    public void handleStopIndex(CreateIndexDesc spec) {
        try {
            VirtualDataWindowEventStopIndex theEvent = new VirtualDataWindowEventStopIndex(spec.getWindowName(), spec.getIndexName());
            this.dataExternal.handleEvent(theEvent);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle stop-index event for window '" + this.namedWindowName + "': " + ex.getMessage();
            log.warn((Object)message, (Throwable)ex);
        }
    }

    @Override
    public void handleStopWindow() {
        try {
            VirtualDataWindowEventStopWindow theEvent = new VirtualDataWindowEventStopWindow(this.namedWindowName);
            this.dataExternal.handleEvent(theEvent);
        }
        catch (Exception ex) {
            String message = "Exception encountered invoking virtual data window handle stop-window event for window '" + this.namedWindowName + "': " + ex.getMessage();
            log.warn((Object)message, (Throwable)ex);
        }
    }
}

