/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.EPRuntimeEventSender;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventAdapterServiceAnonymousTypeCache;
import com.espertech.esper.event.EventAdapterServiceHelper;
import com.espertech.esper.event.EventBeanAdapterFactory;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventBeanSPI;
import com.espertech.esper.event.EventSenderBean;
import com.espertech.esper.event.EventSenderImpl;
import com.espertech.esper.event.EventSenderMap;
import com.espertech.esper.event.EventSenderObjectArray;
import com.espertech.esper.event.EventSenderURIDesc;
import com.espertech.esper.event.EventSenderXMLDOM;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.WrapperEventBean;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.bean.BeanEventAdapter;
import com.espertech.esper.event.bean.BeanEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanEventTypeFactory;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaXMLEventType;
import com.espertech.esper.event.xml.SimpleXMLEventType;
import com.espertech.esper.event.xml.XMLEventBean;
import com.espertech.esper.plugin.PlugInEventBeanFactory;
import com.espertech.esper.plugin.PlugInEventBeanReflectorContext;
import com.espertech.esper.plugin.PlugInEventRepresentation;
import com.espertech.esper.plugin.PlugInEventTypeHandler;
import com.espertech.esper.plugin.PlugInEventTypeHandlerContext;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.URIUtil;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventAdapterServiceImpl
implements EventAdapterService {
    private static Log log = LogFactory.getLog(EventAdapterServiceImpl.class);
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Map<String, EventType> nameToTypeMap;
    private final Map<String, PlugInEventTypeHandler> nameToHandlerMap;
    private BeanEventAdapter beanEventAdapter;
    private Map<String, EventType> xmldomRootElementNames;
    private LinkedHashSet<String> javaPackageNames;
    private final Map<URI, PlugInEventRepresentation> plugInRepresentations;
    private final EventTypeIdGenerator eventTypeIdGenerator;
    private final EventAdapterServiceAnonymousTypeCache anonymousTypeCache;

    public EventAdapterServiceImpl(EventTypeIdGenerator eventTypeIdGenerator, int anonymousTypeCacheSize) {
        this.eventTypeIdGenerator = eventTypeIdGenerator;
        this.nameToTypeMap = new HashMap<String, EventType>();
        this.xmldomRootElementNames = new HashMap<String, EventType>();
        this.javaPackageNames = new LinkedHashSet();
        this.nameToHandlerMap = new HashMap<String, PlugInEventTypeHandler>();
        this.typesPerJavaBean = new ConcurrentHashMap();
        this.beanEventAdapter = new BeanEventAdapter(this.typesPerJavaBean, this, eventTypeIdGenerator);
        this.plugInRepresentations = new HashMap<URI, PlugInEventRepresentation>();
        this.anonymousTypeCache = new EventAdapterServiceAnonymousTypeCache(anonymousTypeCacheSize);
    }

    @Override
    public Map<String, EventType> getDeclaredEventTypes() {
        return new HashMap<String, EventType>(this.nameToTypeMap);
    }

    @Override
    public void setClassLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.beanEventAdapter.setClassToLegacyConfigs(classToLegacyConfigs);
    }

    @Override
    public ConfigurationEventTypeLegacy getClassLegacyConfigs(String className) {
        return this.beanEventAdapter.getClassToLegacyConfigs(className);
    }

    @Override
    public Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType, boolean allowAnyType) {
        return EventAdapterServiceHelper.getWriteableProperties(eventType, allowAnyType);
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventType eventType, WriteablePropertyDescriptor[] properties, EngineImportService engineImportService, boolean allowAnyType) throws EventBeanManufactureException {
        return EventAdapterServiceHelper.getManufacturer(this, eventType, properties, engineImportService, allowAnyType);
    }

    @Override
    public EventType[] getAllTypes() {
        Collection<EventType> types = this.nameToTypeMap.values();
        return types.toArray(new EventType[types.size()]);
    }

    @Override
    public synchronized void addTypeByName(String name, EventType eventType) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(name)) {
            throw new EventAdapterException("Event type by name '" + name + "' already exists");
        }
        this.nameToTypeMap.put(name, eventType);
    }

    @Override
    public void addEventRepresentation(URI eventRepURI, PlugInEventRepresentation pluginEventRep) throws EventAdapterException {
        if (this.plugInRepresentations.containsKey(eventRepURI)) {
            throw new EventAdapterException("Plug-in event representation URI by name " + eventRepURI + " already exists");
        }
        this.plugInRepresentations.put(eventRepURI, pluginEventRep);
    }

    @Override
    public EventType addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(eventTypeName)) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared");
        }
        PlugInEventRepresentation handlingFactory = null;
        URI handledEventTypeURI = null;
        if (resolutionURIs == null || resolutionURIs.length == 0) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as" + " no resolution URIs for dynamic resolution of event type names through a plug-in event representation have been defined");
        }
        for (URI eventTypeURI : resolutionURIs) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(eventTypeURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventTypeHandlerContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsType(context = new PlugInEventTypeHandlerContext(eventTypeURI, initializer, eventTypeName, this.eventTypeIdGenerator.getTypeId(eventTypeName)))) continue;
                handlingFactory = factory;
                handledEventTypeURI = eventTypeURI;
                break;
            }
            if (handlingFactory != null) break;
        }
        if (handlingFactory == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as none of the " + "registered plug-in event representations accepts any of the resolution URIs '" + Arrays.toString(resolutionURIs) + "' and initializer");
        }
        PlugInEventTypeHandlerContext context = new PlugInEventTypeHandlerContext(handledEventTypeURI, initializer, eventTypeName, this.eventTypeIdGenerator.getTypeId(eventTypeName));
        PlugInEventTypeHandler handler = handlingFactory.getTypeHandler(context);
        if (handler == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as no handler was returned");
        }
        EventType eventType = handler.getType();
        this.nameToTypeMap.put(eventTypeName, eventType);
        this.nameToHandlerMap.put(eventTypeName, handler);
        return eventType;
    }

    @Override
    public EventSender getStaticTypeEventSender(EPRuntimeEventSender runtimeEventSender, String eventTypeName, ThreadingService threadingService) throws EventTypeException {
        EventType eventType = this.nameToTypeMap.get(eventTypeName);
        if (eventType == null) {
            throw new EventTypeException("Event type named '" + eventTypeName + "' could not be found");
        }
        if (eventType instanceof BeanEventType) {
            return new EventSenderBean(runtimeEventSender, (BeanEventType)eventType, this, threadingService);
        }
        if (eventType instanceof MapEventType) {
            return new EventSenderMap(runtimeEventSender, (MapEventType)eventType, this, threadingService);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new EventSenderObjectArray(runtimeEventSender, (ObjectArrayEventType)eventType, this, threadingService);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new EventSenderXMLDOM(runtimeEventSender, (BaseXMLEventType)eventType, this, threadingService);
        }
        PlugInEventTypeHandler handlers = this.nameToHandlerMap.get(eventTypeName);
        if (handlers != null) {
            return handlers.getSender(runtimeEventSender);
        }
        throw new EventTypeException("An event sender for event type named '" + eventTypeName + "' could not be created as the type is internal");
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws EventAdapterException {
        EventType type = this.nameToTypeMap.get(mapeventTypeName);
        if (type == null) {
            throw new EventAdapterException("Event type named '" + mapeventTypeName + "' has not been declared");
        }
        if (!(type instanceof MapEventType)) {
            throw new EventAdapterException("Event type by name '" + mapeventTypeName + "' is not a Map event type");
        }
        MapEventType mapEventType = (MapEventType)type;
        mapEventType.addAdditionalProperties(typeMap, this);
    }

    @Override
    public void updateObjectArrayEventType(String objectArrayEventTypeName, Map<String, Object> typeMap) throws EventAdapterException {
        EventType type = this.nameToTypeMap.get(objectArrayEventTypeName);
        if (type == null) {
            throw new EventAdapterException("Event type named '" + objectArrayEventTypeName + "' has not been declared");
        }
        if (!(type instanceof ObjectArrayEventType)) {
            throw new EventAdapterException("Event type by name '" + objectArrayEventTypeName + "' is not an Object-array event type");
        }
        ObjectArrayEventType objectArrayEventType = (ObjectArrayEventType)type;
        objectArrayEventType.addAdditionalProperties(typeMap, this);
    }

    @Override
    public EventSender getDynamicTypeEventSender(EPRuntimeEventSender epRuntime, URI[] uri, ThreadingService threadingService) throws EventTypeException {
        ArrayList<EventSenderURIDesc> handlingFactories = new ArrayList<EventSenderURIDesc>();
        for (URI resolutionURI : uri) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(resolutionURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventBeanReflectorContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsEventBeanResolution(context = new PlugInEventBeanReflectorContext(resolutionURI))) continue;
                PlugInEventBeanFactory beanFactory = factory.getEventBeanFactory(context);
                if (beanFactory == null) {
                    log.warn((Object)"Plug-in event representation returned a null bean factory, ignoring entry");
                    continue;
                }
                EventSenderURIDesc desc = new EventSenderURIDesc(beanFactory, resolutionURI, entry.getKey());
                handlingFactories.add(desc);
            }
        }
        if (handlingFactories.isEmpty()) {
            throw new EventTypeException("Event sender for resolution URIs '" + Arrays.toString(uri) + "' did not return at least one event representation's event factory");
        }
        return new EventSenderImpl(handlingFactories, epRuntime, threadingService);
    }

    @Override
    public BeanEventTypeFactory getBeanEventTypeFactory() {
        return this.beanEventAdapter;
    }

    @Override
    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.beanEventAdapter.setDefaultPropertyResolutionStyle(defaultPropertyResolutionStyle);
    }

    @Override
    public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
        this.beanEventAdapter.setDefaultAccessorStyle(defaultAccessorStyle);
    }

    @Override
    public EventType getExistsTypeByName(String eventTypeName) {
        if (eventTypeName == null) {
            throw new IllegalStateException("Null event type name parameter");
        }
        return this.nameToTypeMap.get(eventTypeName);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, Class clazz, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".addBeanType Adding " + eventTypeName + " for type " + clazz.getName()));
        }
        if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            if (existingType.getUnderlyingType().equals(clazz)) {
                return existingType;
            }
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information:" + existingType.getUnderlyingType().getName() + " versus " + clazz.getName());
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, isPreconfiguredStatic, isPreconfigured, isConfigured);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addBeanTypeByName(String eventTypeName, Class clazz, boolean isNamedWindow) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".addBeanTypeNamedWindow Adding " + eventTypeName + " for type " + clazz.getName()));
        }
        if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            if (existingType instanceof BeanEventType && existingType.getUnderlyingType() == clazz && existingType.getName().equals(eventTypeName)) {
                EventTypeMetadata.TypeClass typeClass = ((BeanEventType)existingType).getMetadata().getTypeClass();
                if (isNamedWindow ? typeClass == EventTypeMetadata.TypeClass.NAMED_WINDOW : typeClass == EventTypeMetadata.TypeClass.STREAM) {
                    return existingType;
                }
            }
            throw new EventAdapterException("An event type named '" + eventTypeName + "' has already been declared");
        }
        EventTypeMetadata.TypeClass typeClass = isNamedWindow ? EventTypeMetadata.TypeClass.NAMED_WINDOW : EventTypeMetadata.TypeClass.STREAM;
        BeanEventType beanEventType = new BeanEventType(EventTypeMetadata.createBeanType(eventTypeName, clazz, false, false, false, typeClass), this.eventTypeIdGenerator.getTypeId(eventTypeName), clazz, this, this.beanEventAdapter.getClassToLegacyConfigs(clazz.getName()));
        this.nameToTypeMap.put(eventTypeName, beanEventType);
        return beanEventType;
    }

    @Override
    public EventBean adapterForBean(Object theEvent) {
        EventType eventType = this.typesPerJavaBean.get(theEvent.getClass());
        if (eventType == null) {
            eventType = this.beanEventAdapter.createBeanType(theEvent.getClass().getName(), theEvent.getClass(), false, false, false);
        }
        return new BeanEventBean(theEvent, eventType);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, String fullyQualClassName, boolean considerAutoName, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured) throws EventAdapterException {
        Class<?> clazz;
        block11: {
            EventType existingType;
            if (log.isDebugEnabled()) {
                log.debug((Object)(".addBeanType Adding " + eventTypeName + " for type " + fullyQualClassName));
            }
            if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
                if (existingType.getUnderlyingType().getName().equals(fullyQualClassName) || existingType.getUnderlyingType().getSimpleName().equals(fullyQualClassName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(".addBeanType Returning existing type for " + eventTypeName));
                    }
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information: Class " + existingType.getUnderlyingType().getName() + " versus " + fullyQualClassName);
            }
            clazz = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(fullyQualClassName, true, cl);
            }
            catch (ClassNotFoundException ex) {
                if (!considerAutoName) {
                    throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
                }
                for (String javaPackageName : this.javaPackageNames) {
                    String generatedClassName = javaPackageName + "." + fullyQualClassName;
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> resolvedClass = Class.forName(generatedClassName, true, cl);
                        if (clazz != null) {
                            throw new EventAdapterException("Failed to resolve name '" + eventTypeName + "', the class was ambigously found both in " + "package '" + clazz.getPackage().getName() + "' and in " + "package '" + resolvedClass.getPackage().getName() + "'", ex);
                        }
                        clazz = resolvedClass;
                    }
                    catch (ClassNotFoundException ex1) {}
                }
                if (clazz != null) break block11;
                throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
            }
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, isPreconfiguredStatic, isPreconfigured, isConfigured);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addNestableMapType(String eventTypeName, Map<String, Object> propertyTypes, ConfigurationEventTypeMap optionalConfig, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean namedWindow, boolean insertInto) throws EventAdapterException {
        Pair<EventType[], Set<EventType>> mapSuperTypes = this.getSuperTypesDepthFirst(optionalConfig != null ? optionalConfig.getSuperTypes() : null, true);
        EventTypeMetadata metadata = EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.MAP, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, namedWindow, insertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        MapEventType newEventType = new MapEventType(metadata, eventTypeName, typeId, this, propertyTypes, mapSuperTypes.getFirst(), mapSuperTypes.getSecond(), optionalConfig);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = newEventType.getEqualsMessage(existingType);
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public synchronized EventType addNestableObjectArrayType(String eventTypeName, Map<String, Object> propertyTypes, ConfigurationEventTypeObjectArray optionalConfig, boolean isPreconfiguredStatic, boolean isPreconfigured, boolean isConfigured, boolean namedWindow, boolean insertInto, boolean table, String tableName) throws EventAdapterException {
        if (optionalConfig != null && optionalConfig.getSuperTypes().size() > 1) {
            throw new EventAdapterException("Object-array event types only allow a single supertype");
        }
        Pair<EventType[], Set<EventType>> mapSuperTypes = this.getSuperTypesDepthFirst(optionalConfig != null ? optionalConfig.getSuperTypes() : null, false);
        EventTypeMetadata metadata = table ? EventTypeMetadata.createTable(tableName) : EventTypeMetadata.createNonPojoApplicationType(EventTypeMetadata.ApplicationType.OBJECTARR, eventTypeName, isPreconfiguredStatic, isPreconfigured, isConfigured, namedWindow, insertInto);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        ObjectArrayEventType newEventType = new ObjectArrayEventType(metadata, eventTypeName, typeId, this, propertyTypes, optionalConfig, mapSuperTypes.getFirst(), mapSuperTypes.getSecond());
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = newEventType.getEqualsMessage(existingType);
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public EventBean adapterForMap(Map<String, Object> theEvent, String eventTypeName) throws EPException {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (!(existingType instanceof MapEventType)) {
            throw new EPException(this.getMessageExpecting(eventTypeName, existingType, "Map"));
        }
        return this.adapterForTypedMap(theEvent, existingType);
    }

    @Override
    public EventBean adapterForObjectArray(Object[] theEvent, String eventTypeName) throws EPException {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (!(existingType instanceof ObjectArrayEventType)) {
            throw new EPException(this.getMessageExpecting(eventTypeName, existingType, "Object-array"));
        }
        return this.adapterForTypedObjectArray(theEvent, existingType);
    }

    @Override
    public EventBean adapterForDOM(Node node) {
        EventType eventType;
        Node namedNode;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = node;
        } else {
            throw new EPException("Unexpected DOM node of type '" + node.getClass() + "' encountered, please supply a Document or Element node");
        }
        String rootElementName = namedNode.getLocalName();
        if (rootElementName == null) {
            rootElementName = namedNode.getNodeName();
        }
        if ((eventType = this.xmldomRootElementNames.get(rootElementName)) == null) {
            throw new EventAdapterException("DOM event root element name '" + rootElementName + "' has not been configured");
        }
        return new XMLEventBean(namedNode, eventType);
    }

    @Override
    public EventBean adapterForTypedDOM(Node node, EventType eventType) {
        return new XMLEventBean(node, eventType);
    }

    @Override
    public synchronized EventType addXMLDOMType(String eventTypeName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, SchemaModel optionalSchemaModel, boolean isPreconfiguredStatic) {
        return this.addXMLDOMType(eventTypeName, configurationEventTypeXMLDOM, optionalSchemaModel, isPreconfiguredStatic, false);
    }

    @Override
    public EventType replaceXMLEventType(String xmlEventTypeName, ConfigurationEventTypeXMLDOM config, SchemaModel schemaModel) {
        return this.addXMLDOMType(xmlEventTypeName, config, schemaModel, false, true);
    }

    private synchronized EventType addXMLDOMType(String eventTypeName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, SchemaModel optionalSchemaModel, boolean isPreconfiguredStatic, boolean allowOverrideExisting) {
        BaseXMLEventType type;
        EventType existingType;
        if (configurationEventTypeXMLDOM.getRootElementName() == null) {
            throw new EventAdapterException("Required root element name has not been supplied");
        }
        if (!allowOverrideExisting && (existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            String message = "Event type named '" + eventTypeName + "' has already been declared with differing column name or type information";
            if (!(existingType instanceof BaseXMLEventType)) {
                throw new EventAdapterException(message);
            }
            ConfigurationEventTypeXMLDOM config = ((BaseXMLEventType)existingType).getConfigurationEventTypeXMLDOM();
            if (!config.equals(configurationEventTypeXMLDOM)) {
                throw new EventAdapterException(message);
            }
            return existingType;
        }
        EventTypeMetadata metadata = EventTypeMetadata.createXMLType(eventTypeName, isPreconfiguredStatic, configurationEventTypeXMLDOM.getSchemaResource() == null && configurationEventTypeXMLDOM.getSchemaText() == null);
        if (configurationEventTypeXMLDOM.getSchemaResource() == null && configurationEventTypeXMLDOM.getSchemaText() == null) {
            type = new SimpleXMLEventType(metadata, this.eventTypeIdGenerator.getTypeId(eventTypeName), configurationEventTypeXMLDOM, this);
        } else {
            if (optionalSchemaModel == null) {
                throw new EPException("Schema model has not been provided");
            }
            type = new SchemaXMLEventType(metadata, this.eventTypeIdGenerator.getTypeId(eventTypeName), configurationEventTypeXMLDOM, optionalSchemaModel, this);
        }
        this.nameToTypeMap.put(eventTypeName, type);
        this.xmldomRootElementNames.put(configurationEventTypeXMLDOM.getRootElementName(), type);
        return type;
    }

    @Override
    public final EventBean adapterForType(Object theEvent, EventType eventType) {
        return EventAdapterServiceHelper.adapterForType(theEvent, eventType, this);
    }

    @Override
    public final EventBean adapterForTypedMap(Map<String, Object> properties, EventType eventType) {
        return new MapEventBean(properties, eventType);
    }

    @Override
    public final EventBean adapterForTypedObjectArray(Object[] properties, EventType eventType) {
        return new ObjectArrayEventBean(properties, eventType);
    }

    @Override
    public synchronized EventType addWrapperType(String eventTypeName, EventType underlyingEventType, Map<String, Object> propertyTypes, boolean isNamedWindow, boolean isInsertInto) throws EventAdapterException {
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypes);
            propertyTypes = propertiesSuperset;
        }
        boolean isPropertyAgnostic = false;
        if (underlyingEventType instanceof EventTypeSPI) {
            isPropertyAgnostic = ((EventTypeSPI)underlyingEventType).getMetadata().isPropertyAgnostic();
        }
        EventTypeMetadata metadata = EventTypeMetadata.createWrapper(eventTypeName, isNamedWindow, isInsertInto, isPropertyAgnostic);
        int typeId = this.eventTypeIdGenerator.getTypeId(eventTypeName);
        WrapperEventType newEventType = new WrapperEventType(metadata, eventTypeName, typeId, underlyingEventType, propertyTypes, this);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equalsCompareType(existingType)) {
                String message = EventAdapterServiceImpl.isCompatibleWrapper(existingType, underlyingEventType, propertyTypes);
                if (message == null) {
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    public static String isCompatibleWrapper(EventType existingType, EventType underlyingType, Map<String, Object> propertyTypes) {
        if (!(existingType instanceof WrapperEventType)) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        WrapperEventType existingWrapper = (WrapperEventType)existingType;
        String message = MapEventType.isDeepEqualsProperties(existingType.getName(), existingWrapper.getUnderlyingMapType().getTypes(), propertyTypes);
        if (message != null) {
            return message;
        }
        EventType existingUnderlyingType = existingWrapper.getUnderlyingEventType();
        if (underlyingType.getSuperTypes() == null) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        Iterator<EventType> it = underlyingType.getDeepSuperTypes();
        while (it.hasNext()) {
            EventType superUnderlying = it.next();
            if (superUnderlying != existingUnderlyingType) continue;
            return null;
        }
        return "Type '" + existingType.getName() + "' is not compatible";
    }

    @Override
    public final EventType createAnonymousMapType(String typeName, Map<String, Object> propertyTypes) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName);
        MapEventType mapEventType = new MapEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), this, propertyTypes, null, null, null);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(mapEventType);
    }

    @Override
    public final EventType createAnonymousObjectArrayType(String typeName, Map<String, Object> propertyTypes) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName);
        ObjectArrayEventType oaEventType = new ObjectArrayEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), this, propertyTypes, null, null, null);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(oaEventType);
    }

    @Override
    public EventType createSemiAnonymousMapType(String typeName, Map<String, Pair<EventType, String>> taggedEventTypes, Map<String, Pair<EventType, String>> arrayEventTypes, boolean isUsedByChildViews) {
        LinkedHashMap<String, Object> mapProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Pair<EventType, String>> entry : taggedEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), entry.getValue().getFirst());
        }
        for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), new EventType[]{entry.getValue().getFirst()});
        }
        return this.createAnonymousMapType(typeName, mapProperties);
    }

    @Override
    public final EventType createAnonymousWrapperType(String typeName, EventType underlyingEventType, Map<String, Object> propertyTypes) throws EventAdapterException {
        String assignedTypeName = "anonymous_" + typeName;
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(assignedTypeName);
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypes);
            propertyTypes = propertiesSuperset;
        }
        WrapperEventType wrapperEventType = new WrapperEventType(metadata, assignedTypeName, this.eventTypeIdGenerator.getTypeId(assignedTypeName), underlyingEventType, propertyTypes, this);
        return this.anonymousTypeCache.addReturnExistingAnonymousType(wrapperEventType);
    }

    @Override
    public final EventBean adapterForTypedWrapper(EventBean theEvent, Map<String, Object> properties, EventType eventType) {
        if (theEvent instanceof DecoratingEventBean) {
            DecoratingEventBean wrapper = (DecoratingEventBean)((Object)theEvent);
            properties.putAll(wrapper.getDecoratingProperties());
            return new WrapperEventBean(wrapper.getUnderlyingEvent(), properties, eventType);
        }
        return new WrapperEventBean(theEvent, properties, eventType);
    }

    @Override
    public final EventBean adapterForTypedBean(Object bean, EventType eventType) {
        return new BeanEventBean(bean, eventType);
    }

    @Override
    public void addAutoNamePackage(String javaPackageName) {
        this.javaPackageNames.add(javaPackageName);
    }

    @Override
    public EventType createAnonymousBeanType(String eventTypeName, Class clazz) {
        BeanEventType beanEventType = new BeanEventType(EventTypeMetadata.createBeanType(eventTypeName, clazz, false, false, false, EventTypeMetadata.TypeClass.ANONYMOUS), -1, clazz, this, this.beanEventAdapter.getClassToLegacyConfigs(clazz.getName()));
        return this.anonymousTypeCache.addReturnExistingAnonymousType(beanEventType);
    }

    private Pair<EventType[], Set<EventType>> getSuperTypesDepthFirst(Set<String> superTypesSet, boolean expectMapType) throws EventAdapterException {
        if (superTypesSet == null || superTypesSet.isEmpty()) {
            return new Pair<Object, Object>(null, null);
        }
        EventType[] superTypes = new EventType[superTypesSet.size()];
        LinkedHashSet<EventType> deepSuperTypes = new LinkedHashSet<EventType>();
        int count = 0;
        for (String superName : superTypesSet) {
            EventType type = this.nameToTypeMap.get(superName);
            if (type == null) {
                throw new EventAdapterException("Supertype by name '" + superName + "' could not be found");
            }
            if (expectMapType) {
                if (!(type instanceof MapEventType)) {
                    throw new EventAdapterException("Supertype by name '" + superName + "' is not a Map, expected a Map event type as a supertype");
                }
            } else if (!(type instanceof ObjectArrayEventType)) {
                throw new EventAdapterException("Supertype by name '" + superName + "' is not an Object-array type, expected a Object-array event type as a supertype");
            }
            superTypes[count++] = type;
            deepSuperTypes.add(type);
            EventAdapterServiceImpl.addRecursiveSupertypes(deepSuperTypes, type);
        }
        ArrayList superTypesListDepthFirst = new ArrayList(deepSuperTypes);
        Collections.reverse(superTypesListDepthFirst);
        return new Pair<EventType[], Set<EventType>>(superTypes, new LinkedHashSet(superTypesListDepthFirst));
    }

    private static void addRecursiveSupertypes(Set<EventType> superTypes, EventType child) {
        if (child.getSuperTypes() != null) {
            for (int i = 0; i < child.getSuperTypes().length; ++i) {
                superTypes.add(child.getSuperTypes()[i]);
                EventAdapterServiceImpl.addRecursiveSupertypes(superTypes, child.getSuperTypes()[i]);
            }
        }
    }

    @Override
    public EventBean[] typeCast(List<EventBean> events, EventType targetType) {
        return EventAdapterServiceHelper.typeCast(events, targetType, this);
    }

    @Override
    public boolean removeType(String name) {
        EventType eventType = this.nameToTypeMap.remove(name);
        if (eventType == null) {
            return false;
        }
        if (eventType instanceof BaseXMLEventType) {
            BaseXMLEventType baseXML = (BaseXMLEventType)eventType;
            this.xmldomRootElementNames.remove(baseXML.getRootElementName());
        }
        this.nameToHandlerMap.remove(name);
        return true;
    }

    @Override
    public EventBeanSPI getShellForType(EventType eventType) {
        return EventAdapterServiceHelper.getShellForType(eventType);
    }

    private String getMessageExpecting(String eventTypeName, EventType existingType, String typeOfEventType) {
        String message = "Event type named '" + eventTypeName + "' has not been defined or is not a " + typeOfEventType + " event type";
        message = existingType != null ? message + ", the name '" + eventTypeName + "' refers to a " + JavaClassHelper.getClassNameFullyQualPretty(existingType.getUnderlyingType()) + " event type" : message + ", the name '" + eventTypeName + "' has not been defined as an event type";
        return message;
    }

    @Override
    public EventBeanAdapterFactory getAdapterFactoryForType(EventType eventType) {
        return EventAdapterServiceHelper.getAdapterFactoryForType(eventType);
    }
}

