/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;

public class InstanceManufacturerUtil {
    public static Pair<FastConstructor, ExprEvaluator[]> getManufacturer(Class targetClass, EngineImportService engineImportService, ExprEvaluator[] exprEvaluators, Object[] expressionReturnTypes) throws ExprValidationException {
        Class[] ctorTypes = new Class[expressionReturnTypes.length];
        ExprEvaluator[] evaluators = new ExprEvaluator[exprEvaluators.length];
        for (int i = 0; i < expressionReturnTypes.length; ++i) {
            ExprEvaluator inner;
            EventType columnEventType;
            Object columnType = expressionReturnTypes[i];
            if (columnType instanceof Class || columnType == null) {
                ctorTypes[i] = (Class)expressionReturnTypes[i];
                evaluators[i] = exprEvaluators[i];
                continue;
            }
            if (columnType instanceof EventType) {
                columnEventType = (EventType)columnType;
                final Class returnType = columnEventType.getUnderlyingType();
                inner = exprEvaluators[i];
                evaluators[i] = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean theEvent = (EventBean)inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                        if (theEvent != null) {
                            return theEvent.getUnderlying();
                        }
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return returnType;
                    }
                };
                ctorTypes[i] = returnType;
                continue;
            }
            if (columnType instanceof EventType[]) {
                columnEventType = ((EventType[])columnType)[0];
                final Class componentReturnType = columnEventType.getUnderlyingType();
                inner = exprEvaluators[i];
                evaluators[i] = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        Object result = inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                        if (!(result instanceof EventBean[])) {
                            return null;
                        }
                        EventBean[] events = (EventBean[])result;
                        Object values = Array.newInstance(componentReturnType, events.length);
                        for (int i = 0; i < events.length; ++i) {
                            Array.set(values, i, events[i].getUnderlying());
                        }
                        return values;
                    }

                    @Override
                    public Class getType() {
                        return componentReturnType;
                    }
                };
                continue;
            }
            String message = "Invalid assignment of expression " + i + " returning type '" + columnType + "', column and parameter types mismatch";
            throw new ExprValidationException(message);
        }
        try {
            Constructor ctor = engineImportService.resolveCtor(targetClass, ctorTypes);
            FastClass fastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), (Class)targetClass);
            return new Pair<FastConstructor, ExprEvaluator[]>(fastClass.getConstructor(ctor), evaluators);
        }
        catch (EngineImportException ex) {
            throw new ExprValidationException("Failed to find a suitable constructor for class '" + targetClass.getName() + "': " + ex.getMessage(), ex);
        }
    }
}

