/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.NestedPropertyGetter;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapNestedPropertyGetterMapOnly;
import com.espertech.esper.event.map.MapNestedPropertyGetterMixedType;
import com.espertech.esper.event.property.DynamicProperty;
import com.espertech.esper.event.property.DynamicSimpleProperty;
import com.espertech.esper.event.property.GenericPropertyDesc;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyBase;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.DOMNestedPropertyGetter;
import com.espertech.esper.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItem;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NestedProperty
implements Property {
    private List<Property> properties;

    public NestedProperty(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isDynamic() {
        for (Property property : this.properties) {
            if (!property.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public EventPropertyGetter getGetter(BeanEventType eventType, EventAdapterService eventAdapterService) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        Property lastProperty = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property;
            lastProperty = property = it.next();
            EventPropertyGetter getter = property.getGetter(eventType, eventAdapterService);
            if (getter == null) {
                return null;
            }
            if (it.hasNext()) {
                Class clazz = property.getPropertyType(eventType, eventAdapterService);
                if (clazz == null) {
                    return null;
                }
                if (clazz == Map.class) {
                    return null;
                }
                if (clazz.isArray()) {
                    return null;
                }
                eventType = eventAdapterService.getBeanEventTypeFactory().createBeanType(clazz.getName(), clazz, false, false, false);
            }
            getters.add(getter);
        }
        GenericPropertyDesc finalPropertyType = lastProperty.getPropertyTypeGeneric(eventType, eventAdapterService);
        return new NestedPropertyGetter(getters, eventAdapterService, finalPropertyType.getType(), finalPropertyType.getGeneric());
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, EventAdapterService eventAdapterService) {
        Class result = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            result = property.getPropertyType(eventType, eventAdapterService);
            if (result == null) {
                return null;
            }
            if (!it.hasNext()) continue;
            if (result == Map.class) {
                return null;
            }
            if (result.isArray() || result.isPrimitive() || JavaClassHelper.isJavaBuiltinDataType(result)) {
                return null;
            }
            eventType = eventAdapterService.getBeanEventTypeFactory().createBeanType(result.getName(), result, false, false, false);
        }
        return result;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, EventAdapterService eventAdapterService) {
        GenericPropertyDesc result = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            result = property.getPropertyTypeGeneric(eventType, eventAdapterService);
            if (result == null) {
                return null;
            }
            if (!it.hasNext()) continue;
            if (result.getType() == Map.class) {
                return null;
            }
            if (result.getType().isArray()) {
                return null;
            }
            eventType = eventAdapterService.getBeanEventTypeFactory().createBeanType(result.getType().getName(), result.getType(), false, false, false);
        }
        return result;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        Map currentDictionary = optionalMapPropTypes;
        int count = 0;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            ++count;
            Property property = it.next();
            PropertyBase theBase = (PropertyBase)property;
            String propertyName = theBase.getPropertyNameAtomic();
            Object nestedType = null;
            if (currentDictionary != null) {
                nestedType = currentDictionary.get(propertyName);
            }
            if (nestedType == null) {
                if (property instanceof DynamicProperty) {
                    return Object.class;
                }
                return null;
            }
            if (!it.hasNext()) {
                if (nestedType instanceof Class) {
                    return (Class)nestedType;
                }
                if (nestedType instanceof Map) {
                    return Map.class;
                }
            }
            if (nestedType == Map.class) {
                return Object.class;
            }
            if (nestedType instanceof Class) {
                Class pojoClass = (Class)nestedType;
                if (!pojoClass.isArray()) {
                    BeanEventType beanType = eventAdapterService.getBeanEventTypeFactory().createBeanType(pojoClass.getName(), pojoClass, false, false, false);
                    String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                    return beanType.getPropertyType(remainingProps);
                }
                if (property instanceof IndexedProperty) {
                    Class<?> componentType = pojoClass.getComponentType();
                    BeanEventType beanType = eventAdapterService.getBeanEventTypeFactory().createBeanType(componentType.getName(), componentType, false, false, false);
                    String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                    return beanType.getPropertyType(remainingProps);
                }
            }
            if (nestedType instanceof String) {
                EventType innerType;
                String nestedName = nestedType.toString();
                boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
                if (isArray) {
                    nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
                }
                if ((innerType = eventAdapterService.getExistsTypeByName(nestedName)) == null) {
                    return null;
                }
                String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                return innerType.getPropertyType(remainingProps);
            }
            if (nestedType instanceof EventType) {
                EventType innerType = (EventType)nestedType;
                String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                return innerType.getPropertyType(remainingProps);
            }
            if (!(nestedType instanceof Map)) {
                String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
                throw new PropertyAccessException(message);
            }
            currentDictionary = (Map)nestedType;
        }
        throw new IllegalStateException("Unexpected end of nested property");
    }

    @Override
    public MapEventPropertyGetter getGetterMap(Map optionalMapPropTypes, EventAdapterService eventAdapterService) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        Map currentDictionary = optionalMapPropTypes;
        int count = 0;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            EventPropertyGetter getterInner;
            String remainingProps;
            ++count;
            Property property = it.next();
            MapEventPropertyGetter getter = property.getGetterMap(currentDictionary, eventAdapterService);
            if (getter == null) {
                return null;
            }
            getters.add(getter);
            PropertyBase theBase = (PropertyBase)property;
            String propertyName = theBase.getPropertyNameAtomic();
            if (!it.hasNext() || currentDictionary == null) continue;
            Object propertyReturnType = currentDictionary.get(propertyName);
            if (propertyReturnType == null) {
                currentDictionary = null;
            }
            if (propertyReturnType == null) continue;
            if (propertyReturnType instanceof Map) {
                currentDictionary = (Map)propertyReturnType;
                continue;
            }
            if (propertyReturnType == Map.class) {
                currentDictionary = null;
                continue;
            }
            if (propertyReturnType instanceof String) {
                EventType innerType;
                String nestedName = propertyReturnType.toString();
                boolean isArray = EventTypeUtility.isPropertyArray(nestedName);
                if (isArray) {
                    nestedName = EventTypeUtility.getPropertyRemoveArray(nestedName);
                }
                if ((innerType = eventAdapterService.getExistsTypeByName(nestedName)) == null) {
                    return null;
                }
                remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                getterInner = innerType.getGetter(remainingProps);
                if (getterInner == null) {
                    return null;
                }
                getters.add(getterInner);
                break;
            }
            if (propertyReturnType instanceof EventType) {
                EventType innerType = (EventType)propertyReturnType;
                String remainingProps2 = NestedProperty.toPropertyEPL(this.properties, count);
                EventPropertyGetter getterInner2 = innerType.getGetter(remainingProps2);
                if (getterInner2 == null) {
                    return null;
                }
                getters.add(getterInner2);
                break;
            }
            Class pojoClass = (Class)propertyReturnType;
            if (!pojoClass.isArray()) {
                String remainingProps3;
                BeanEventType beanType = eventAdapterService.getBeanEventTypeFactory().createBeanType(pojoClass.getName(), pojoClass, false, false, false);
                EventPropertyGetter getterInner3 = beanType.getGetter(remainingProps3 = NestedProperty.toPropertyEPL(this.properties, count));
                if (getterInner3 == null) {
                    return null;
                }
                getters.add(getterInner3);
                break;
            }
            Class<?> componentType = pojoClass.getComponentType();
            BeanEventType beanType = eventAdapterService.getBeanEventTypeFactory().createBeanType(componentType.getName(), componentType, false, false, false);
            getterInner = beanType.getGetter(remainingProps = NestedProperty.toPropertyEPL(this.properties, count));
            if (getterInner == null) {
                return null;
            }
            getters.add(getterInner);
            break;
        }
        boolean hasNonmapGetters = false;
        for (int i = 0; i < getters.size(); ++i) {
            if (getters.get(i) instanceof MapEventPropertyGetter) continue;
            hasNonmapGetters = true;
        }
        if (!hasNonmapGetters) {
            return new MapNestedPropertyGetterMapOnly(getters, eventAdapterService);
        }
        return new MapNestedPropertyGetterMixedType(getters, eventAdapterService);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        String delimiter = "";
        for (Property property : this.properties) {
            writer.append(delimiter);
            property.toPropertyEPL(writer);
            delimiter = ".";
        }
    }

    @Override
    public String[] toPropertyArray() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Property property : this.properties) {
            String[] nested = property.toPropertyArray();
            propertyNames.addAll(Arrays.asList(nested));
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    @Override
    public EventPropertyGetter getGetterDOM() {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        for (Property property : this.properties) {
            EventPropertyGetter getter = property.getGetterDOM();
            if (getter == null) {
                return null;
            }
            getters.add(getter);
        }
        return new DOMNestedPropertyGetter(getters, null);
    }

    @Override
    public EventPropertyGetter getGetterDOM(SchemaElementComplex parentComplexProperty, EventAdapterService eventAdapterService, BaseXMLEventType eventType, String propertyExpression) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        SchemaElementComplex complexElement = parentComplexProperty;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            EventPropertyGetter getter = property.getGetterDOM(complexElement, eventAdapterService, eventType, propertyExpression);
            if (getter == null) {
                return null;
            }
            if (it.hasNext()) {
                SchemaItem childSchemaItem = property.getPropertyTypeSchema(complexElement, eventAdapterService);
                if (childSchemaItem == null) {
                    return null;
                }
                if (childSchemaItem instanceof SchemaItemAttribute || childSchemaItem instanceof SchemaElementSimple) {
                    return null;
                }
                complexElement = (SchemaElementComplex)childSchemaItem;
                if (complexElement.isArray() && (property instanceof SimpleProperty || property instanceof DynamicSimpleProperty)) {
                    return null;
                }
            }
            getters.add(getter);
        }
        return new DOMNestedPropertyGetter(getters, new FragmentFactoryDOMGetter(eventAdapterService, eventType, propertyExpression));
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex parentComplexProperty, EventAdapterService eventAdapterService) {
        Property lastProperty = null;
        SchemaElementComplex complexElement = parentComplexProperty;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property;
            lastProperty = property = it.next();
            if (!it.hasNext()) continue;
            SchemaItem childSchemaItem = property.getPropertyTypeSchema(complexElement, eventAdapterService);
            if (childSchemaItem == null) {
                return null;
            }
            if (childSchemaItem instanceof SchemaItemAttribute || childSchemaItem instanceof SchemaElementSimple) {
                return null;
            }
            complexElement = (SchemaElementComplex)childSchemaItem;
        }
        return lastProperty.getPropertyTypeSchema(complexElement, eventAdapterService);
    }

    @Override
    public ObjectArrayEventPropertyGetter getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventAdapterService eventAdapterService) {
        throw new UnsupportedOperationException("Object array nested property getter not implemented as not implicitly nestable");
    }

    @Override
    public String getPropertyNameAtomic() {
        throw new UnsupportedOperationException("Nested properties do not provide an atomic property name");
    }

    private static String toPropertyEPL(List<Property> property, int startFromIndex) {
        String delimiter = "";
        StringWriter writer = new StringWriter();
        for (int i = startFromIndex; i < property.size(); ++i) {
            writer.append(delimiter);
            property.get(i).toPropertyEPL(writer);
            delimiter = ".";
        }
        return writer.getBuffer().toString();
    }
}

