/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.vaevent.PropertyGroupDesc;
import com.espertech.esper.event.vaevent.PropertyUtility;
import com.espertech.esper.event.vaevent.RevisionBeanHolder;
import com.espertech.esper.event.vaevent.RevisionEventBeanDeclared;
import com.espertech.esper.event.vaevent.RevisionEventType;
import com.espertech.esper.event.vaevent.RevisionGetterParameters;
import com.espertech.esper.event.vaevent.RevisionPropertyTypeDesc;
import com.espertech.esper.event.vaevent.RevisionSpec;
import com.espertech.esper.event.vaevent.RevisionStateDeclared;
import com.espertech.esper.event.vaevent.RevisionTypeDesc;
import com.espertech.esper.event.vaevent.VAERevisionProcessorBase;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.StatementStopService;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VAERevisionProcessorDeclared
extends VAERevisionProcessorBase
implements ValueAddEventProcessor {
    private static final Log log = LogFactory.getLog(VAERevisionProcessorDeclared.class);
    private final PropertyGroupDesc[] groups;
    private final EventType baseEventType;
    private final EventPropertyGetter[] fullKeyGetters;
    private Map<Object, RevisionStateDeclared> statePerKey;

    public VAERevisionProcessorDeclared(String revisionEventTypeName, RevisionSpec spec, StatementStopService statementStopService, EventAdapterService eventAdapterService, EventTypeIdGenerator eventTypeIdGenerator) {
        super(spec, revisionEventTypeName, eventAdapterService);
        statementStopService.addSubscriber(new StatementStopCallback(){

            @Override
            public void statementStopped() {
                VAERevisionProcessorDeclared.this.statePerKey.clear();
            }
        });
        this.statePerKey = new HashMap<Object, RevisionStateDeclared>();
        this.baseEventType = spec.getBaseEventType();
        this.fullKeyGetters = PropertyUtility.getGetters(this.baseEventType, spec.getKeyPropertyNames());
        this.groups = PropertyUtility.analyzeGroups(spec.getChangesetPropertyNames(), spec.getDeltaTypes(), spec.getDeltaNames());
        Map<String, RevisionPropertyTypeDesc> propertyDesc = VAERevisionProcessorDeclared.createPropertyDescriptors(spec, this.groups);
        this.typeDescriptors = PropertyUtility.getPerType(this.groups, spec.getChangesetPropertyNames(), spec.getKeyPropertyNames());
        EventTypeMetadata metadata = EventTypeMetadata.createValueAdd(revisionEventTypeName, EventTypeMetadata.TypeClass.REVISION);
        this.revisionEventType = new RevisionEventType(metadata, eventTypeIdGenerator.getTypeId(revisionEventTypeName), propertyDesc, eventAdapterService);
    }

    @Override
    public EventBean getValueAddEventBean(EventBean theEvent) {
        return new RevisionEventBeanDeclared(this.revisionEventType, theEvent);
    }

    @Override
    public void onUpdate(EventBean[] newData, EventBean[] oldData, NamedWindowRootViewInstance namedWindowRootView, EventTableIndexRepository indexRepository) {
        if (newData == null || newData.length == 0) {
            RevisionEventBeanDeclared revisionEvent = (RevisionEventBeanDeclared)oldData[0];
            Object key = revisionEvent.getKey();
            this.statePerKey.remove(key);
            for (EventTable table : indexRepository.getTables()) {
                table.remove(oldData);
            }
            revisionEvent.setLatest(false);
            namedWindowRootView.updateChildren(null, oldData);
            return;
        }
        RevisionEventBeanDeclared revisionEvent = (RevisionEventBeanDeclared)newData[0];
        EventBean underlyingEvent = revisionEvent.getUnderlyingFullOrDelta();
        EventType underyingEventType = underlyingEvent.getEventType();
        Object key = null;
        RevisionTypeDesc typesDesc = null;
        boolean isBaseEventType = false;
        if (underyingEventType == this.baseEventType) {
            key = PropertyUtility.getKeys(underlyingEvent, this.fullKeyGetters);
            isBaseEventType = true;
        } else {
            typesDesc = (RevisionTypeDesc)this.typeDescriptors.get(underyingEventType);
            if (typesDesc == null) {
                Iterator<EventType> superTypes = underyingEventType.getDeepSuperTypes();
                if (superTypes != null) {
                    while (superTypes.hasNext()) {
                        EventType superType = superTypes.next();
                        if (superType == this.baseEventType) {
                            key = PropertyUtility.getKeys(underlyingEvent, this.fullKeyGetters);
                            isBaseEventType = true;
                        } else {
                            typesDesc = (RevisionTypeDesc)this.typeDescriptors.get(superType);
                            if (typesDesc == null) continue;
                            this.typeDescriptors.put(underyingEventType, typesDesc);
                            key = PropertyUtility.getKeys(underlyingEvent, typesDesc.getKeyPropertyGetters());
                        }
                        break;
                    }
                }
            } else {
                key = PropertyUtility.getKeys(underlyingEvent, typesDesc.getKeyPropertyGetters());
            }
        }
        RevisionStateDeclared revisionState = this.statePerKey.get(key);
        if (!isBaseEventType && revisionState == null) {
            return;
        }
        if (revisionState == null) {
            revisionState = new RevisionStateDeclared(underlyingEvent, null, null);
            this.statePerKey.put(key, revisionState);
            revisionEvent.setLastBaseEvent(underlyingEvent);
            revisionEvent.setKey(key);
            revisionEvent.setHolders(null);
            revisionEvent.setLatest(true);
            for (EventTable table : indexRepository.getTables()) {
                table.add(newData);
            }
            revisionState.setLastEvent(revisionEvent);
            namedWindowRootView.updateChildren(new EventBean[]{revisionEvent}, null);
            return;
        }
        long versionNumber = revisionState.incRevisionNumber();
        if (isBaseEventType) {
            revisionState.setHolders(null);
            revisionState.setBaseEventUnderlying(underlyingEvent);
        } else {
            int groupNum = typesDesc.getGroup().getGroupNum();
            RevisionBeanHolder[] holders = revisionState.getHolders();
            holders = holders == null ? new RevisionBeanHolder[this.groups.length] : this.arrayCopy(holders);
            holders[groupNum] = new RevisionBeanHolder(versionNumber, underlyingEvent, typesDesc.getChangesetPropertyGetters());
            revisionState.setHolders(holders);
        }
        revisionEvent.setLastBaseEvent(revisionState.getBaseEventUnderlying());
        revisionEvent.setHolders(revisionState.getHolders());
        revisionEvent.setKey(key);
        revisionEvent.setLatest(true);
        RevisionEventBeanDeclared lastEvent = revisionState.getLastEvent();
        lastEvent.setLatest(false);
        EventBean[] newDataPost = new EventBean[]{revisionEvent};
        EventBean[] oldDataPost = new EventBean[]{lastEvent};
        for (EventTable table : indexRepository.getTables()) {
            table.remove(oldDataPost);
            table.add(newDataPost);
        }
        revisionState.setLastEvent(revisionEvent);
        namedWindowRootView.updateChildren(newDataPost, oldDataPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventBean> getSnapshot(EPStatementAgentInstanceHandle createWindowStmtHandle, Viewable parent) {
        createWindowStmtHandle.getStatementAgentInstanceLock().acquireReadLock();
        try {
            Iterator<EventBean> it = parent.iterator();
            if (!it.hasNext()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
            while (it.hasNext()) {
                RevisionEventBeanDeclared fullRevision = (RevisionEventBeanDeclared)it.next();
                Object key = fullRevision.getKey();
                RevisionStateDeclared state = this.statePerKey.get(key);
                list.add(state.getLastEvent());
            }
            ArrayDeque<EventBean> arrayDeque = list;
            return arrayDeque;
        }
        finally {
            createWindowStmtHandle.getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    @Override
    public void removeOldData(EventBean[] oldData, EventTableIndexRepository indexRepository) {
        for (int i = 0; i < oldData.length; ++i) {
            RevisionEventBeanDeclared theEvent = (RevisionEventBeanDeclared)oldData[i];
            if (!theEvent.isLatest()) continue;
            Object key = theEvent.getKey();
            this.statePerKey.remove(key);
            for (EventTable table : indexRepository.getTables()) {
                table.remove(oldData);
            }
        }
    }

    private RevisionBeanHolder[] arrayCopy(RevisionBeanHolder[] array) {
        if (array == null) {
            return null;
        }
        RevisionBeanHolder[] result = new RevisionBeanHolder[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static Map<String, RevisionPropertyTypeDesc> createPropertyDescriptors(RevisionSpec spec, PropertyGroupDesc[] groups) {
        RevisionPropertyTypeDesc propertyTypeDesc;
        Class type;
        EventPropertyGetter fullGetter;
        Map<String, int[]> propsPerGroup = PropertyUtility.getGroupsPerProperty(groups);
        HashMap<String, RevisionPropertyTypeDesc> propertyDesc = new HashMap<String, RevisionPropertyTypeDesc>();
        int count = 0;
        for (String property : spec.getChangesetPropertyNames()) {
            fullGetter = spec.getBaseEventType().getGetter(property);
            int propertyNumber = count++;
            int[] propGroupsProperty = propsPerGroup.get(property);
            final RevisionGetterParameters parameters = new RevisionGetterParameters(property, propertyNumber, fullGetter, propGroupsProperty);
            EventPropertyGetter revisionGetter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanDeclared riv = (RevisionEventBeanDeclared)eventBean;
                    return riv.getVersionedValue(parameters);
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            };
            Class type2 = spec.getBaseEventType().getPropertyType(property);
            RevisionPropertyTypeDesc propertyTypeDesc2 = new RevisionPropertyTypeDesc(revisionGetter, parameters, type2);
            propertyDesc.put(property, propertyTypeDesc2);
        }
        for (String property : spec.getBaseEventOnlyPropertyNames()) {
            fullGetter = spec.getBaseEventType().getGetter(property);
            EventPropertyGetter revisionGetter = new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanDeclared riv = (RevisionEventBeanDeclared)eventBean;
                    EventBean bean = riv.getLastBaseEvent();
                    if (bean == null) {
                        return null;
                    }
                    return fullGetter.get(bean);
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            };
            type = spec.getBaseEventType().getPropertyType(property);
            propertyTypeDesc = new RevisionPropertyTypeDesc(revisionGetter, null, type);
            propertyDesc.put(property, propertyTypeDesc);
            ++count;
        }
        count = 0;
        for (String property : spec.getKeyPropertyNames()) {
            final int keyPropertyNumber = count;
            EventPropertyGetter revisionGetter = spec.getKeyPropertyNames().length == 1 ? new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanDeclared riv = (RevisionEventBeanDeclared)eventBean;
                    return riv.getKey();
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            } : new EventPropertyGetter(){

                @Override
                public Object get(EventBean eventBean) throws PropertyAccessException {
                    RevisionEventBeanDeclared riv = (RevisionEventBeanDeclared)eventBean;
                    MultiKeyUntyped key = (MultiKeyUntyped)riv.getKey();
                    if (key == null) {
                        return null;
                    }
                    return key.getKeys()[keyPropertyNumber];
                }

                @Override
                public boolean isExistsProperty(EventBean eventBean) {
                    return true;
                }

                @Override
                public Object getFragment(EventBean eventBean) {
                    return null;
                }
            };
            type = spec.getBaseEventType().getPropertyType(property);
            propertyTypeDesc = new RevisionPropertyTypeDesc(revisionGetter, null, type);
            propertyDesc.put(property, propertyTypeDesc);
            ++count;
        }
        return propertyDesc;
    }
}

