/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import org.w3c.dom.Node;

public class DOMConvertingGetter
implements EventPropertyGetter {
    private final DOMPropertyGetter getter;
    private final SimpleTypeParser parser;

    public DOMConvertingGetter(String propertyExpression, DOMPropertyGetter domPropertyGetter, Class returnType) {
        this.getter = domPropertyGetter;
        this.parser = SimpleTypeParserFactory.getParser(returnType);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        if (!(obj.getUnderlying() instanceof Node)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type Node");
        }
        Node node = (Node)obj.getUnderlying();
        Node result = this.getter.getValueAsNode(node);
        if (result == null) {
            return null;
        }
        String text = result.getTextContent();
        if (text == null) {
            return null;
        }
        return this.parser.parse(text);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

