/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.FragmentFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPropertyArrayItemGetter
implements EventPropertyGetter {
    private final EventPropertyGetter getter;
    private final int index;
    private final FragmentFactory fragmentFactory;

    public XPathPropertyArrayItemGetter(EventPropertyGetter getter, int index, FragmentFactory fragmentFactory) {
        this.getter = getter;
        this.index = index;
        this.fragmentFactory = fragmentFactory;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object result = this.getter.get(eventBean);
        if (!(result instanceof NodeList)) {
            return null;
        }
        NodeList nodeList = (NodeList)result;
        if (nodeList.getLength() <= this.index) {
            return null;
        }
        return nodeList.item(this.index);
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        if (this.fragmentFactory == null) {
            return null;
        }
        Node result = (Node)this.get(eventBean);
        if (result == null) {
            return null;
        }
        return this.fragmentFactory.getEvent(result);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

